/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec;

import com.espertech.esper.epl.expression.ExprAndNodeImpl;
import com.espertech.esper.epl.expression.ExprEqualsNodeImpl;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.type.OuterJoinType;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.Collection;

public class OuterJoinDesc
implements MetaDefItem,
Serializable {
    public static final OuterJoinDesc[] EMPTY_OUTERJOIN_ARRAY = new OuterJoinDesc[0];
    private OuterJoinType outerJoinType;
    private ExprIdentNode optLeftNode;
    private ExprIdentNode optRightNode;
    private ExprIdentNode[] optAddLeftNode;
    private ExprIdentNode[] optAddRightNode;
    private static final long serialVersionUID = -2616847070429124382L;

    public OuterJoinDesc(OuterJoinType outerJoinType, ExprIdentNode optLeftNode, ExprIdentNode optRightNode, ExprIdentNode[] optAddLeftNode, ExprIdentNode[] optAddRightNode) {
        this.outerJoinType = outerJoinType;
        this.optLeftNode = optLeftNode;
        this.optRightNode = optRightNode;
        this.optAddLeftNode = optAddLeftNode;
        this.optAddRightNode = optAddRightNode;
    }

    public OuterJoinType getOuterJoinType() {
        return this.outerJoinType;
    }

    public ExprIdentNode getOptLeftNode() {
        return this.optLeftNode;
    }

    public ExprIdentNode getOptRightNode() {
        return this.optRightNode;
    }

    public ExprIdentNode[] getAdditionalLeftNodes() {
        return this.optAddLeftNode;
    }

    public ExprIdentNode[] getAdditionalRightNodes() {
        return this.optAddRightNode;
    }

    public ExprNode makeExprNode(ExprEvaluatorContext exprEvaluatorContext) {
        ExprNodeBase representativeNode = new ExprEqualsNodeImpl(false, false);
        representativeNode.addChildNode(this.optLeftNode);
        representativeNode.addChildNode(this.optRightNode);
        if (this.optAddLeftNode == null) {
            this.topValidate(representativeNode, exprEvaluatorContext);
            return representativeNode;
        }
        ExprAndNodeImpl andNode = new ExprAndNodeImpl();
        this.topValidate(representativeNode, exprEvaluatorContext);
        andNode.addChildNode(representativeNode);
        representativeNode = andNode;
        for (int i = 0; i < this.optAddLeftNode.length; ++i) {
            ExprEqualsNodeImpl eqNode = new ExprEqualsNodeImpl(false, false);
            eqNode.addChildNode(this.optAddLeftNode[i]);
            eqNode.addChildNode(this.optAddRightNode[i]);
            this.topValidate(eqNode, exprEvaluatorContext);
            andNode.addChildNode(eqNode);
        }
        this.topValidate(andNode, exprEvaluatorContext);
        return representativeNode;
    }

    public static boolean consistsOfAllInnerJoins(OuterJoinDesc[] outerJoinDescList) {
        for (OuterJoinDesc desc : outerJoinDescList) {
            if (desc.getOuterJoinType() == OuterJoinType.INNER) continue;
            return false;
        }
        return true;
    }

    public static OuterJoinDesc[] toArray(Collection<OuterJoinDesc> expressions) {
        if (expressions.isEmpty()) {
            return EMPTY_OUTERJOIN_ARRAY;
        }
        return expressions.toArray(new OuterJoinDesc[expressions.size()]);
    }

    private void topValidate(ExprNode exprNode, ExprEvaluatorContext exprEvaluatorContext) {
        try {
            ExprValidationContext validationContext = new ExprValidationContext(null, null, null, null, null, exprEvaluatorContext, null, null, null, null, null);
            exprNode.validate(validationContext);
        }
        catch (ExprValidationException e) {
            throw new IllegalStateException("Failed to make representative node for outer join criteria");
        }
    }
}

