/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec.util;

import com.espertech.esper.client.soda.AnnotationPart;
import com.espertech.esper.client.soda.AssignmentPair;
import com.espertech.esper.client.soda.ContainedEventSelect;
import com.espertech.esper.client.soda.ContextDescriptor;
import com.espertech.esper.client.soda.ContextDescriptorCategory;
import com.espertech.esper.client.soda.ContextDescriptorCategoryItem;
import com.espertech.esper.client.soda.ContextDescriptorCondition;
import com.espertech.esper.client.soda.ContextDescriptorConditionCrontab;
import com.espertech.esper.client.soda.ContextDescriptorConditionFilter;
import com.espertech.esper.client.soda.ContextDescriptorConditionPattern;
import com.espertech.esper.client.soda.ContextDescriptorConditionTimePeriod;
import com.espertech.esper.client.soda.ContextDescriptorHashSegmented;
import com.espertech.esper.client.soda.ContextDescriptorHashSegmentedItem;
import com.espertech.esper.client.soda.ContextDescriptorInitiatedTerminated;
import com.espertech.esper.client.soda.ContextDescriptorKeyedSegmented;
import com.espertech.esper.client.soda.ContextDescriptorKeyedSegmentedItem;
import com.espertech.esper.client.soda.ContextDescriptorNested;
import com.espertech.esper.client.soda.CreateContextClause;
import com.espertech.esper.client.soda.CreateSchemaClause;
import com.espertech.esper.client.soda.DataFlowOperator;
import com.espertech.esper.client.soda.DataFlowOperatorParameter;
import com.espertech.esper.client.soda.EPStatementObjectModel;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionDeclaration;
import com.espertech.esper.client.soda.Filter;
import com.espertech.esper.client.soda.FilterStream;
import com.espertech.esper.client.soda.ForClauseItem;
import com.espertech.esper.client.soda.MatchRecognizeDefine;
import com.espertech.esper.client.soda.MatchRecognizeRegEx;
import com.espertech.esper.client.soda.MethodInvocationStream;
import com.espertech.esper.client.soda.OnInsertSplitStreamClause;
import com.espertech.esper.client.soda.OnInsertSplitStreamItem;
import com.espertech.esper.client.soda.OnMergeClause;
import com.espertech.esper.client.soda.OnMergeMatchItem;
import com.espertech.esper.client.soda.OnMergeMatchedAction;
import com.espertech.esper.client.soda.OnMergeMatchedDeleteAction;
import com.espertech.esper.client.soda.OnMergeMatchedInsertAction;
import com.espertech.esper.client.soda.OnMergeMatchedUpdateAction;
import com.espertech.esper.client.soda.OnSetClause;
import com.espertech.esper.client.soda.OnUpdateClause;
import com.espertech.esper.client.soda.OrderByElement;
import com.espertech.esper.client.soda.OuterJoinQualifier;
import com.espertech.esper.client.soda.PatternExpr;
import com.espertech.esper.client.soda.PatternFilterExpr;
import com.espertech.esper.client.soda.PatternStream;
import com.espertech.esper.client.soda.ProjectedStream;
import com.espertech.esper.client.soda.PropertyValueExpressionPair;
import com.espertech.esper.client.soda.SelectClauseElement;
import com.espertech.esper.client.soda.SelectClauseExpression;
import com.espertech.esper.client.soda.Stream;
import com.espertech.esper.client.soda.View;
import com.espertech.esper.epl.spec.util.SODAAnalyzerPatternCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SODAAnalyzer {
    public static List<CreateSchemaClause> analyzeModelCreateSchema(EPStatementObjectModel model) {
        if (model.getCreateDataFlow() == null || model.getCreateDataFlow().getSchemas() == null) {
            return Collections.emptyList();
        }
        return new ArrayList<CreateSchemaClause>(model.getCreateDataFlow().getSchemas());
    }

    public static List<EPStatementObjectModel> analyzeModelSelectStatements(EPStatementObjectModel model) {
        if (model.getCreateDataFlow() == null) {
            return Collections.emptyList();
        }
        ArrayList<EPStatementObjectModel> models = new ArrayList<EPStatementObjectModel>();
        if (model.getCreateDataFlow() != null) {
            for (DataFlowOperator op : model.getCreateDataFlow().getOperators()) {
                if (op.getParameters() == null || op.getParameters().isEmpty()) continue;
                for (DataFlowOperatorParameter param : op.getParameters()) {
                    if (!(param.getParameterValue() instanceof EPStatementObjectModel)) continue;
                    models.add((EPStatementObjectModel)param.getParameterValue());
                }
            }
        }
        return models;
    }

    public static List<AnnotationPart> analyzeModelAnnotations(EPStatementObjectModel model) {
        ArrayList<AnnotationPart> annotations = new ArrayList<AnnotationPart>();
        if (model.getAnnotations() != null) {
            annotations.addAll(model.getAnnotations());
        }
        if (model.getCreateDataFlow() != null) {
            for (DataFlowOperator op : model.getCreateDataFlow().getOperators()) {
                if (op.getAnnotations() == null) continue;
                annotations.addAll(op.getAnnotations());
            }
        }
        return annotations;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Expression> analyzeModelExpressions(EPStatementObjectModel model) {
        Expression expr;
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (model.getCreateExpression() != null && model.getCreateExpression().getExpressionDeclaration() != null && model.getCreateExpression().getExpressionDeclaration().getExpression() != null) {
            expressions.add(model.getCreateExpression().getExpressionDeclaration().getExpression());
        }
        if (model.getExpressionDeclarations() != null) {
            for (ExpressionDeclaration decl : model.getExpressionDeclarations()) {
                expressions.add(decl.getExpression());
            }
        }
        if (model.getCreateContext() != null) {
            ContextDescriptor desc = model.getCreateContext().getDescriptor();
            SODAAnalyzer.collectExpressionsContextDesc(desc, expressions);
        }
        if (model.getCreateVariable() != null && (expr = model.getCreateVariable().getOptionalAssignment()) != null) {
            expressions.add(expr);
        }
        if (model.getCreateWindow() != null) {
            expr = model.getCreateWindow().getInsertWhereClause();
            if (expr != null) {
                expressions.add(expr);
            }
            for (View view : model.getCreateWindow().getViews()) {
                expressions.addAll(view.getParameters());
            }
        }
        if (model.getUpdateClause() != null) {
            if (model.getUpdateClause().getOptionalWhereClause() != null) {
                expressions.add(model.getUpdateClause().getOptionalWhereClause());
            }
            if (model.getUpdateClause().getAssignments() != null) {
                for (AssignmentPair pair : model.getUpdateClause().getAssignments()) {
                    expressions.add(pair.getValue());
                }
            }
        }
        if (model.getOnExpr() != null) {
            OnUpdateClause onUpdate;
            OnSetClause onSet;
            if (model.getOnExpr() instanceof OnInsertSplitStreamClause) {
                OnInsertSplitStreamClause onSplit = (OnInsertSplitStreamClause)model.getOnExpr();
                for (OnInsertSplitStreamItem onInsertSplitStreamItem : onSplit.getItems()) {
                    if (onInsertSplitStreamItem.getSelectClause() != null) {
                        for (SelectClauseElement selement : onInsertSplitStreamItem.getSelectClause().getSelectList()) {
                            if (!(selement instanceof SelectClauseExpression)) continue;
                            SelectClauseExpression sexpr = (SelectClauseExpression)selement;
                            expressions.add(sexpr.getExpression());
                        }
                    }
                    if (onInsertSplitStreamItem.getWhereClause() == null) continue;
                    expressions.add(onInsertSplitStreamItem.getWhereClause());
                }
            }
            if (model.getOnExpr() instanceof OnSetClause && (onSet = (OnSetClause)model.getOnExpr()).getAssignments() != null) {
                for (AssignmentPair assignmentPair : onSet.getAssignments()) {
                    expressions.add(assignmentPair.getValue());
                }
            }
            if (model.getOnExpr() instanceof OnUpdateClause && (onUpdate = (OnUpdateClause)model.getOnExpr()).getAssignments() != null) {
                for (AssignmentPair assignmentPair : onUpdate.getAssignments()) {
                    expressions.add(assignmentPair.getValue());
                }
            }
            if (model.getOnExpr() instanceof OnMergeClause) {
                OnMergeClause onMerge = (OnMergeClause)model.getOnExpr();
                for (OnMergeMatchItem onMergeMatchItem : onMerge.getMatchItems()) {
                    if (onMergeMatchItem.getOptionalCondition() != null) {
                        expressions.add(onMergeMatchItem.getOptionalCondition());
                    }
                    for (OnMergeMatchedAction action : onMergeMatchItem.getActions()) {
                        if (action instanceof OnMergeMatchedDeleteAction) {
                            OnMergeMatchedDeleteAction delete = (OnMergeMatchedDeleteAction)action;
                            if (delete.getWhereClause() == null) continue;
                            expressions.add(delete.getWhereClause());
                            continue;
                        }
                        if (action instanceof OnMergeMatchedUpdateAction) {
                            OnMergeMatchedUpdateAction update = (OnMergeMatchedUpdateAction)action;
                            if (update.getWhereClause() != null) {
                                expressions.add(update.getWhereClause());
                            }
                            for (AssignmentPair assignment : update.getAssignments()) {
                                expressions.add(assignment.getValue());
                            }
                            continue;
                        }
                        if (!(action instanceof OnMergeMatchedInsertAction)) continue;
                        OnMergeMatchedInsertAction insert = (OnMergeMatchedInsertAction)action;
                        if (insert.getWhereClause() != null) {
                            expressions.add(insert.getWhereClause());
                        }
                        for (SelectClauseElement element : insert.getSelectList()) {
                            if (!(element instanceof SelectClauseExpression)) continue;
                            SelectClauseExpression expr2 = (SelectClauseExpression)element;
                            expressions.add(expr2.getExpression());
                        }
                    }
                }
            }
        }
        if (model.getSelectClause() != null && model.getSelectClause().getSelectList() != null) {
            for (SelectClauseElement selectItem : model.getSelectClause().getSelectList()) {
                if (!(selectItem instanceof SelectClauseExpression)) continue;
                SelectClauseExpression selectClauseExpression = (SelectClauseExpression)selectItem;
                expressions.add(selectClauseExpression.getExpression());
            }
        }
        if (model.getFromClause() != null) {
            for (Stream stream : model.getFromClause().getStreams()) {
                ProjectedStream projectedStream;
                MethodInvocationStream methodInvocationStream;
                if (stream instanceof FilterStream) {
                    FilterStream filterStream = (FilterStream)stream;
                    Filter filter = filterStream.getFilter();
                    if (filter != null && filter.getFilter() != null) {
                        expressions.add(filterStream.getFilter().getFilter());
                    }
                    if (filter != null && filter.getOptionalPropertySelects() != null) {
                        for (ContainedEventSelect contained : filter.getOptionalPropertySelects()) {
                            for (SelectClauseElement selectItem : contained.getSelectClause().getSelectList()) {
                                if (!(selectItem instanceof SelectClauseExpression)) continue;
                                SelectClauseExpression selectExpr = (SelectClauseExpression)selectItem;
                                expressions.add(selectExpr.getExpression());
                            }
                            if (contained.getWhereClause() == null) continue;
                            expressions.add(contained.getWhereClause());
                        }
                    }
                }
                if (stream instanceof PatternStream) {
                    PatternStream patternStream = (PatternStream)stream;
                    SODAAnalyzer.collectPatternExpressions(expressions, patternStream.getExpression());
                }
                if (stream instanceof MethodInvocationStream && (methodInvocationStream = (MethodInvocationStream)stream).getParameterExpressions() != null) {
                    expressions.addAll(methodInvocationStream.getParameterExpressions());
                }
                if (!(stream instanceof ProjectedStream) || (projectedStream = (ProjectedStream)stream).getViews() == null) continue;
                for (View view : projectedStream.getViews()) {
                    expressions.addAll(view.getParameters());
                }
            }
            if (model.getFromClause().getOuterJoinQualifiers() != null) {
                for (OuterJoinQualifier q : model.getFromClause().getOuterJoinQualifiers()) {
                    expressions.add(q.getLeft());
                    expressions.add(q.getRight());
                    for (PropertyValueExpressionPair pair : q.getAdditionalProperties()) {
                        expressions.add(pair.getLeft());
                        expressions.add(pair.getRight());
                    }
                }
            }
        }
        if (model.getWhereClause() != null) {
            expressions.add(model.getWhereClause());
        }
        if (model.getGroupByClause() != null) {
            for (Expression groupByExpr : model.getGroupByClause().getGroupByExpressions()) {
                expressions.add(groupByExpr);
            }
        }
        if (model.getHavingClause() != null) {
            expressions.add(model.getHavingClause());
        }
        if (model.getOutputLimitClause() != null) {
            if (model.getOutputLimitClause().getWhenExpression() != null) {
                expressions.add(model.getOutputLimitClause().getWhenExpression());
            }
            if (model.getOutputLimitClause().getAndAfterTerminateAndExpr() != null) {
                expressions.add(model.getOutputLimitClause().getAndAfterTerminateAndExpr());
            }
            if (model.getOutputLimitClause().getThenAssignments() != null) {
                for (AssignmentPair thenAssign : model.getOutputLimitClause().getThenAssignments()) {
                    expressions.add(thenAssign.getValue());
                }
            }
            if (model.getOutputLimitClause().getAndAfterTerminateThenAssignments() != null) {
                for (AssignmentPair thenAssign : model.getOutputLimitClause().getAndAfterTerminateThenAssignments()) {
                    expressions.add(thenAssign.getValue());
                }
            }
            if (model.getOutputLimitClause().getCrontabAtParameters() != null) {
                void var4_30;
                Expression[] arr$ = model.getOutputLimitClause().getCrontabAtParameters();
                int len$ = arr$.length;
                boolean bl = false;
                while (var4_30 < len$) {
                    Expression expr3 = arr$[var4_30];
                    expressions.add(expr3);
                    ++var4_30;
                }
            }
            if (model.getOutputLimitClause().getTimePeriodExpression() != null) {
                expressions.add(model.getOutputLimitClause().getTimePeriodExpression());
            }
            if (model.getOutputLimitClause().getAfterTimePeriodExpression() != null) {
                expressions.add(model.getOutputLimitClause().getAfterTimePeriodExpression());
            }
        }
        if (model.getOrderByClause() != null) {
            for (OrderByElement orderByElement : model.getOrderByClause().getOrderByExpressions()) {
                expressions.add(orderByElement.getExpression());
            }
        }
        if (model.getMatchRecognizeClause() != null) {
            if (model.getMatchRecognizeClause().getPartitionExpressions() != null) {
                for (Expression partitionExpr : model.getMatchRecognizeClause().getPartitionExpressions()) {
                    expressions.add(partitionExpr);
                }
            }
            for (SelectClauseExpression selectItemMR : model.getMatchRecognizeClause().getMeasures()) {
                if (!(selectItemMR instanceof SelectClauseExpression)) continue;
                SelectClauseExpression selectClauseExpression = selectItemMR;
                expressions.add(selectClauseExpression.getExpression());
            }
            for (MatchRecognizeDefine define : model.getMatchRecognizeClause().getDefines()) {
                expressions.add(define.getExpression());
            }
            if (model.getMatchRecognizeClause().getIntervalClause() != null && model.getMatchRecognizeClause().getIntervalClause().getExpression() != null) {
                expressions.add(model.getMatchRecognizeClause().getIntervalClause().getExpression());
            }
        }
        if (model.getForClause() != null) {
            for (ForClauseItem item : model.getForClause().getItems()) {
                if (item.getExpressions() == null) continue;
                expressions.addAll(item.getExpressions());
            }
        }
        if (model.getCreateDataFlow() != null) {
            for (DataFlowOperator op : model.getCreateDataFlow().getOperators()) {
                if (op.getParameters() == null || op.getParameters().isEmpty()) continue;
                for (DataFlowOperatorParameter param : op.getParameters()) {
                    if (!(param.getParameterValue() instanceof Expression)) continue;
                    expressions.add((Expression)param.getParameterValue());
                }
            }
        }
        return expressions;
    }

    private static void collectExpressionsContextDesc(ContextDescriptor desc, List<Expression> expressions) {
        if (desc instanceof ContextDescriptorKeyedSegmented) {
            ContextDescriptorKeyedSegmented ks = (ContextDescriptorKeyedSegmented)desc;
            for (ContextDescriptorKeyedSegmentedItem contextDescriptorKeyedSegmentedItem : ks.getItems()) {
                if (contextDescriptorKeyedSegmentedItem.getFilter().getFilter() == null) continue;
                expressions.add(contextDescriptorKeyedSegmentedItem.getFilter().getFilter());
            }
        }
        if (desc instanceof ContextDescriptorCategory) {
            ContextDescriptorCategory cat = (ContextDescriptorCategory)desc;
            for (ContextDescriptorCategoryItem contextDescriptorCategoryItem : cat.getItems()) {
                if (contextDescriptorCategoryItem.getExpression() == null) continue;
                expressions.add(contextDescriptorCategoryItem.getExpression());
            }
            if (cat.getFilter().getFilter() != null) {
                expressions.add(cat.getFilter().getFilter());
            }
        }
        if (desc instanceof ContextDescriptorInitiatedTerminated) {
            ContextDescriptorInitiatedTerminated ts = (ContextDescriptorInitiatedTerminated)desc;
            SODAAnalyzer.collectContextConditionExpressions(expressions, ts.getStartCondition());
            SODAAnalyzer.collectContextConditionExpressions(expressions, ts.getEndCondition());
        }
        if (desc instanceof ContextDescriptorHashSegmented) {
            ContextDescriptorHashSegmented hs = (ContextDescriptorHashSegmented)desc;
            for (ContextDescriptorHashSegmentedItem contextDescriptorHashSegmentedItem : hs.getItems()) {
                if (contextDescriptorHashSegmentedItem.getFilter().getFilter() != null) {
                    expressions.add(contextDescriptorHashSegmentedItem.getFilter().getFilter());
                }
                if (contextDescriptorHashSegmentedItem.getHashFunction() == null) continue;
                expressions.add(contextDescriptorHashSegmentedItem.getHashFunction());
            }
        }
        if (desc instanceof ContextDescriptorNested) {
            ContextDescriptorNested nested = (ContextDescriptorNested)desc;
            for (CreateContextClause createContextClause : nested.getContexts()) {
                SODAAnalyzer.collectExpressionsContextDesc(createContextClause.getDescriptor(), expressions);
            }
        }
    }

    private static void collectContextConditionExpressions(List<Expression> expressions, ContextDescriptorCondition condition) {
        if (condition instanceof ContextDescriptorConditionCrontab) {
            ContextDescriptorConditionCrontab crontab = (ContextDescriptorConditionCrontab)condition;
            expressions.addAll(crontab.getCrontabExpressions());
        } else if (condition instanceof ContextDescriptorConditionFilter) {
            ContextDescriptorConditionFilter filter = (ContextDescriptorConditionFilter)condition;
            if (filter != null && filter.getFilter() != null && filter.getFilter().getFilter() != null) {
                expressions.add(filter.getFilter().getFilter());
            }
        } else if (condition instanceof ContextDescriptorConditionPattern) {
            ContextDescriptorConditionPattern pattern = (ContextDescriptorConditionPattern)condition;
            SODAAnalyzer.collectPatternExpressions(expressions, pattern.getPattern());
        } else if (condition instanceof ContextDescriptorConditionTimePeriod) {
            ContextDescriptorConditionTimePeriod ts = (ContextDescriptorConditionTimePeriod)condition;
            expressions.add(ts.getTimePeriod());
        }
    }

    private static void collectPatternExpressions(final List<Expression> expressions, PatternExpr expression) {
        SODAAnalyzerPatternCollector collector = new SODAAnalyzerPatternCollector(){

            @Override
            public void visit(PatternExpr patternExpr) {
                PatternFilterExpr filter;
                if (patternExpr instanceof PatternFilterExpr && (filter = (PatternFilterExpr)patternExpr).getFilter().getFilter() != null) {
                    expressions.add(filter.getFilter().getFilter());
                }
            }
        };
        SODAAnalyzer.traversePatternRecursive(expression, collector);
    }

    private static void traversePatternRecursive(PatternExpr patternExpr, SODAAnalyzerPatternCollector collectorFunction) {
        collectorFunction.visit(patternExpr);
        if (patternExpr == null) {
            return;
        }
        if (patternExpr.getChildren() == null) {
            return;
        }
        for (PatternExpr child : patternExpr.getChildren()) {
            SODAAnalyzer.traversePatternRecursive(child, collectorFunction);
        }
    }

    public static List<MatchRecognizeRegEx> analyzeModelMatchRecogRegexs(EPStatementObjectModel model) {
        if (model.getMatchRecognizeClause() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(model.getMatchRecognizeClause().getPattern());
    }

    public static List<PatternExpr> analyzeModelPatterns(EPStatementObjectModel model) {
        ContextDescriptor desc;
        ArrayList<PatternExpr> result = new ArrayList<PatternExpr>();
        if (model.getFromClause() != null) {
            for (Stream stream : model.getFromClause().getStreams()) {
                PatternStream patternStream;
                if (!(stream instanceof PatternStream) || (patternStream = (PatternStream)stream).getExpression() == null) continue;
                result.add(patternStream.getExpression());
            }
        }
        if (model.getCreateContext() != null && (desc = model.getCreateContext().getDescriptor()) instanceof ContextDescriptorInitiatedTerminated) {
            ContextDescriptorInitiatedTerminated cat = (ContextDescriptorInitiatedTerminated)desc;
            SODAAnalyzer.analyzeContextCondition(cat.getStartCondition(), result);
            SODAAnalyzer.analyzeContextCondition(cat.getEndCondition(), result);
        }
        return result;
    }

    private static void analyzeContextCondition(ContextDescriptorCondition condition, List<PatternExpr> result) {
        ContextDescriptorConditionPattern pattern;
        if (condition instanceof ContextDescriptorConditionPattern && (pattern = (ContextDescriptorConditionPattern)condition).getPattern() != null) {
            result.add(pattern.getPattern());
        }
    }
}

