/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec.util;

import com.espertech.esper.client.EPException;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetail;
import com.espertech.esper.epl.spec.ContextDetailCategory;
import com.espertech.esper.epl.spec.ContextDetailCategoryItem;
import com.espertech.esper.epl.spec.ContextDetailCondition;
import com.espertech.esper.epl.spec.ContextDetailConditionCrontab;
import com.espertech.esper.epl.spec.ContextDetailInitiatedTerminated;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.epl.spec.ContextDetailPartitioned;
import com.espertech.esper.epl.spec.ExpressionDeclItem;
import com.espertech.esper.epl.spec.FilterSpecRaw;
import com.espertech.esper.epl.spec.FilterStreamSpecRaw;
import com.espertech.esper.epl.spec.ForClauseItemSpec;
import com.espertech.esper.epl.spec.MatchRecognizeDefineItem;
import com.espertech.esper.epl.spec.MatchRecognizeMeasureItem;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.epl.spec.OnTriggerDesc;
import com.espertech.esper.epl.spec.OnTriggerMergeAction;
import com.espertech.esper.epl.spec.OnTriggerMergeActionDelete;
import com.espertech.esper.epl.spec.OnTriggerMergeActionInsert;
import com.espertech.esper.epl.spec.OnTriggerMergeActionUpdate;
import com.espertech.esper.epl.spec.OnTriggerMergeDesc;
import com.espertech.esper.epl.spec.OnTriggerMergeMatched;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.OnTriggerSetDesc;
import com.espertech.esper.epl.spec.OnTriggerSplitStream;
import com.espertech.esper.epl.spec.OnTriggerSplitStreamDesc;
import com.espertech.esper.epl.spec.OnTriggerWindowUpdateDesc;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.epl.spec.PatternStreamSpecRaw;
import com.espertech.esper.epl.spec.PropertyEvalAtom;
import com.espertech.esper.epl.spec.SelectClauseElementRaw;
import com.espertech.esper.epl.spec.SelectClauseExprRawSpec;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.spec.StreamSpecBase;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.pattern.EvalFactoryNode;
import com.espertech.esper.pattern.EvalFilterFactoryNode;
import com.espertech.esper.pattern.EvalNodeAnalysisResult;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.pattern.EvalObserverFactoryNode;
import java.util.ArrayList;
import java.util.List;

public class StatementSpecRawAnalyzer {
    public static List<FilterSpecRaw> analyzeFilters(StatementSpecRaw spec) throws ExprValidationException {
        ArrayList<FilterSpecRaw> result = new ArrayList<FilterSpecRaw>();
        StatementSpecRawAnalyzer.addFilters(spec, result);
        ExprNodeSubselectDeclaredDotVisitor subselects = StatementSpecRawAnalyzer.walkSubselectAndDeclaredDotExpr(spec);
        for (ExprSubselectNode subselect : subselects.getSubselects()) {
            StatementSpecRawAnalyzer.addFilters(subselect.getStatementSpecRaw(), result);
        }
        return result;
    }

    private static void addFilters(StatementSpecRaw spec, List<FilterSpecRaw> filters) {
        for (StreamSpecRaw raw : spec.getStreamSpecs()) {
            StreamSpecBase r;
            if (raw instanceof FilterStreamSpecRaw) {
                r = (FilterStreamSpecRaw)raw;
                filters.add(((FilterStreamSpecRaw)r).getRawFilterSpec());
            }
            if (!(raw instanceof PatternStreamSpecRaw)) continue;
            r = (PatternStreamSpecRaw)raw;
            EvalNodeAnalysisResult evalNodeAnalysisResult = EvalNodeUtil.recursiveAnalyzeChildNodes(((PatternStreamSpecRaw)r).getEvalFactoryNode());
            List<EvalFilterFactoryNode> filterNodes = evalNodeAnalysisResult.getFilterNodes();
            for (EvalFilterFactoryNode filterNode : filterNodes) {
                filters.add(filterNode.getRawFilterSpec());
            }
        }
    }

    public static ExprNodeSubselectDeclaredDotVisitor walkSubselectAndDeclaredDotExpr(StatementSpecRaw spec) throws ExprValidationException {
        ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
        for (SelectClauseElementRaw raw : spec.getSelectClauseSpec().getSelectExprList()) {
            if (!(raw instanceof SelectClauseExprRawSpec)) continue;
            SelectClauseExprRawSpec rawExpr = (SelectClauseExprRawSpec)raw;
            rawExpr.getSelectExpression().accept(visitor);
        }
        if (spec.getFilterRootNode() != null) {
            spec.getFilterRootNode().accept(visitor);
        }
        if (spec.getUpdateDesc() != null) {
            if (spec.getUpdateDesc().getOptionalWhereClause() != null) {
                spec.getUpdateDesc().getOptionalWhereClause().accept(visitor);
            }
            for (OnTriggerSetAssignment assignment : spec.getUpdateDesc().getAssignments()) {
                assignment.getExpression().accept(visitor);
            }
        }
        if (spec.getOnTriggerDesc() != null) {
            StatementSpecRawAnalyzer.visitSubselectOnTrigger(spec.getOnTriggerDesc(), visitor);
        }
        for (StreamSpecRaw streamSpecRaw : spec.getStreamSpecs()) {
            if (!(streamSpecRaw instanceof PatternStreamSpecRaw)) continue;
            PatternStreamSpecRaw patternStreamSpecRaw = (PatternStreamSpecRaw)streamSpecRaw;
            EvalNodeAnalysisResult analysisResult = EvalNodeUtil.recursiveAnalyzeChildNodes(patternStreamSpecRaw.getEvalFactoryNode());
            for (EvalFactoryNode evalNode : analysisResult.getActiveNodes()) {
                if (evalNode instanceof EvalFilterFactoryNode) {
                    EvalFilterFactoryNode filterNode = (EvalFilterFactoryNode)evalNode;
                    for (ExprNode filterExpr : filterNode.getRawFilterSpec().getFilterExpressions()) {
                        filterExpr.accept(visitor);
                    }
                    continue;
                }
                if (!(evalNode instanceof EvalObserverFactoryNode)) continue;
                int beforeCount = visitor.getSubselects().size();
                EvalObserverFactoryNode observerNode = (EvalObserverFactoryNode)evalNode;
                for (ExprNode param : observerNode.getPatternObserverSpec().getObjectParameters()) {
                    param.accept(visitor);
                }
                if (visitor.getSubselects().size() == beforeCount) continue;
                throw new ExprValidationException("Subselects are not allowed within pattern observer parameters, please consider using a variable instead");
            }
        }
        for (StreamSpecRaw rawSpec : spec.getStreamSpecs()) {
            if (!(rawSpec instanceof FilterStreamSpecRaw)) continue;
            FilterStreamSpecRaw raw = (FilterStreamSpecRaw)rawSpec;
            for (ExprNode filterExpr : raw.getRawFilterSpec().getFilterExpressions()) {
                filterExpr.accept(visitor);
            }
        }
        return visitor;
    }

    private static void visitSubselectOnTrigger(OnTriggerDesc onTriggerDesc, ExprNodeSubselectDeclaredDotVisitor visitor) {
        block13: {
            block15: {
                block14: {
                    block12: {
                        if (!(onTriggerDesc instanceof OnTriggerWindowUpdateDesc)) break block12;
                        OnTriggerWindowUpdateDesc updates = (OnTriggerWindowUpdateDesc)onTriggerDesc;
                        for (OnTriggerSetAssignment assignment : updates.getAssignments()) {
                            assignment.getExpression().accept(visitor);
                        }
                        break block13;
                    }
                    if (!(onTriggerDesc instanceof OnTriggerSetDesc)) break block14;
                    OnTriggerSetDesc sets = (OnTriggerSetDesc)onTriggerDesc;
                    for (OnTriggerSetAssignment assignment : sets.getAssignments()) {
                        assignment.getExpression().accept(visitor);
                    }
                    break block13;
                }
                if (!(onTriggerDesc instanceof OnTriggerSplitStreamDesc)) break block15;
                OnTriggerSplitStreamDesc splits = (OnTriggerSplitStreamDesc)onTriggerDesc;
                for (OnTriggerSplitStream split : splits.getSplitStreams()) {
                    if (split.getWhereClause() != null) {
                        split.getWhereClause().accept(visitor);
                    }
                    if (split.getSelectClause().getSelectExprList() == null) continue;
                    for (SelectClauseElementRaw element : split.getSelectClause().getSelectExprList()) {
                        if (!(element instanceof SelectClauseExprRawSpec)) continue;
                        SelectClauseExprRawSpec selectExpr = (SelectClauseExprRawSpec)element;
                        selectExpr.getSelectExpression().accept(visitor);
                    }
                }
                break block13;
            }
            if (!(onTriggerDesc instanceof OnTriggerMergeDesc)) break block13;
            OnTriggerMergeDesc merge = (OnTriggerMergeDesc)onTriggerDesc;
            for (OnTriggerMergeMatched matched : merge.getItems()) {
                if (matched.getOptionalMatchCond() != null) {
                    matched.getOptionalMatchCond().accept(visitor);
                }
                for (OnTriggerMergeAction action : matched.getActions()) {
                    if (action.getOptionalWhereClause() != null) {
                        action.getOptionalWhereClause().accept(visitor);
                    }
                    if (action instanceof OnTriggerMergeActionUpdate) {
                        OnTriggerMergeActionUpdate update = (OnTriggerMergeActionUpdate)action;
                        for (OnTriggerSetAssignment assignment : update.getAssignments()) {
                            assignment.getExpression().accept(visitor);
                        }
                    }
                    if (!(action instanceof OnTriggerMergeActionInsert)) continue;
                    OnTriggerMergeActionInsert insert = (OnTriggerMergeActionInsert)action;
                    for (SelectClauseElementRaw element : insert.getSelectClause()) {
                        if (!(element instanceof SelectClauseExprRawSpec)) continue;
                        SelectClauseExprRawSpec selectExpr = (SelectClauseExprRawSpec)element;
                        selectExpr.getSelectExpression().accept(visitor);
                    }
                }
            }
        }
    }

    public static List<ExprNode> collectExpressionsShallow(StatementSpecRaw raw) {
        ExprNode expr;
        ArrayList<ExprNode> expressions = new ArrayList<ExprNode>();
        if (raw.getExpressionDeclDesc() != null) {
            for (ExpressionDeclItem decl : raw.getExpressionDeclDesc().getExpressions()) {
                expressions.add(decl.getInner());
            }
        }
        if (raw.getCreateExpressionDesc() != null && raw.getCreateExpressionDesc().getExpression() != null) {
            expressions.add(raw.getCreateExpressionDesc().getExpression().getInner());
        }
        if (raw.getCreateContextDesc() != null) {
            ContextDetail detail = raw.getCreateContextDesc().getContextDetail();
            if (detail instanceof ContextDetailPartitioned) {
                ContextDetailPartitioned ks = (ContextDetailPartitioned)detail;
                for (ContextDetailPartitionItem contextDetailPartitionItem : ks.getItems()) {
                    if (contextDetailPartitionItem.getFilterSpecRaw().getFilterExpressions() == null) continue;
                    expressions.addAll(contextDetailPartitionItem.getFilterSpecRaw().getFilterExpressions());
                }
            } else if (detail instanceof ContextDetailCategory) {
                ContextDetailCategory cat = (ContextDetailCategory)detail;
                for (ContextDetailCategoryItem contextDetailCategoryItem : cat.getItems()) {
                    if (contextDetailCategoryItem.getExpression() == null) continue;
                    expressions.add(contextDetailCategoryItem.getExpression());
                }
                if (cat.getFilterSpecRaw().getFilterExpressions() != null) {
                    expressions.addAll(cat.getFilterSpecRaw().getFilterExpressions());
                }
            } else if (detail instanceof ContextDetailInitiatedTerminated) {
                ContextDetailInitiatedTerminated ts = (ContextDetailInitiatedTerminated)detail;
                StatementSpecRawAnalyzer.collectExpressions(expressions, ts.getStart());
                StatementSpecRawAnalyzer.collectExpressions(expressions, ts.getEnd());
            } else {
                throw new EPException("Failed to obtain expressions from context detail " + detail);
            }
        }
        if (raw.getCreateVariableDesc() != null && (expr = raw.getCreateVariableDesc().getAssignment()) != null) {
            expressions.add(expr);
        }
        if (raw.getCreateWindowDesc() != null) {
            expr = raw.getCreateWindowDesc().getInsertFilter();
            if (expr != null) {
                expressions.add(expr);
            }
            for (ViewSpec viewSpec : raw.getCreateWindowDesc().getViewSpecs()) {
                expressions.addAll(viewSpec.getObjectParameters());
            }
        }
        if (raw.getUpdateDesc() != null) {
            if (raw.getUpdateDesc().getOptionalWhereClause() != null) {
                expressions.add(raw.getUpdateDesc().getOptionalWhereClause());
            }
            if (raw.getUpdateDesc().getAssignments() != null) {
                for (OnTriggerSetAssignment pair : raw.getUpdateDesc().getAssignments()) {
                    expressions.add(pair.getExpression());
                }
            }
        }
        if (raw.getOnTriggerDesc() != null) {
            OnTriggerWindowUpdateDesc onUpdate;
            OnTriggerSetDesc onSet;
            if (raw.getOnTriggerDesc() instanceof OnTriggerSplitStreamDesc) {
                OnTriggerSplitStreamDesc onSplit = (OnTriggerSplitStreamDesc)raw.getOnTriggerDesc();
                for (OnTriggerSplitStream onTriggerSplitStream : onSplit.getSplitStreams()) {
                    if (onTriggerSplitStream.getSelectClause() != null) {
                        StatementSpecRawAnalyzer.addSelectClause(expressions, onTriggerSplitStream.getSelectClause().getSelectExprList());
                    }
                    if (onTriggerSplitStream.getWhereClause() == null) continue;
                    expressions.add(onTriggerSplitStream.getWhereClause());
                }
            }
            if (raw.getOnTriggerDesc() instanceof OnTriggerSetDesc && (onSet = (OnTriggerSetDesc)raw.getOnTriggerDesc()).getAssignments() != null) {
                for (OnTriggerSetAssignment onTriggerSetAssignment : onSet.getAssignments()) {
                    expressions.add(onTriggerSetAssignment.getExpression());
                }
            }
            if (raw.getOnTriggerDesc() instanceof OnTriggerWindowUpdateDesc && (onUpdate = (OnTriggerWindowUpdateDesc)raw.getOnTriggerDesc()).getAssignments() != null) {
                for (OnTriggerSetAssignment onTriggerSetAssignment : onUpdate.getAssignments()) {
                    expressions.add(onTriggerSetAssignment.getExpression());
                }
            }
            if (raw.getOnTriggerDesc() instanceof OnTriggerMergeDesc) {
                OnTriggerMergeDesc onMerge = (OnTriggerMergeDesc)raw.getOnTriggerDesc();
                for (OnTriggerMergeMatched onTriggerMergeMatched : onMerge.getItems()) {
                    if (onTriggerMergeMatched.getOptionalMatchCond() != null) {
                        expressions.add(onTriggerMergeMatched.getOptionalMatchCond());
                    }
                    for (OnTriggerMergeAction action : onTriggerMergeMatched.getActions()) {
                        if (action instanceof OnTriggerMergeActionDelete) {
                            OnTriggerMergeActionDelete onTriggerMergeActionDelete = (OnTriggerMergeActionDelete)action;
                            if (onTriggerMergeActionDelete.getOptionalWhereClause() == null) continue;
                            expressions.add(onTriggerMergeActionDelete.getOptionalWhereClause());
                            continue;
                        }
                        if (action instanceof OnTriggerMergeActionUpdate) {
                            OnTriggerMergeActionUpdate onTriggerMergeActionUpdate = (OnTriggerMergeActionUpdate)action;
                            if (onTriggerMergeActionUpdate.getOptionalWhereClause() != null) {
                                expressions.add(onTriggerMergeActionUpdate.getOptionalWhereClause());
                            }
                            for (OnTriggerSetAssignment assignment : onTriggerMergeActionUpdate.getAssignments()) {
                                expressions.add(assignment.getExpression());
                            }
                            continue;
                        }
                        if (!(action instanceof OnTriggerMergeActionInsert)) continue;
                        OnTriggerMergeActionInsert onTriggerMergeActionInsert = (OnTriggerMergeActionInsert)action;
                        if (onTriggerMergeActionInsert.getOptionalWhereClause() != null) {
                            expressions.add(onTriggerMergeActionInsert.getOptionalWhereClause());
                        }
                        StatementSpecRawAnalyzer.addSelectClause(expressions, onTriggerMergeActionInsert.getSelectClause());
                    }
                }
            }
        }
        if (raw.getSelectClauseSpec() != null) {
            StatementSpecRawAnalyzer.addSelectClause(expressions, raw.getSelectClauseSpec().getSelectExprList());
        }
        if (raw.getStreamSpecs() != null) {
            for (StreamSpecRaw stream : raw.getStreamSpecs()) {
                MethodStreamSpec methodStreamSpec;
                if (stream instanceof FilterStreamSpecRaw) {
                    FilterStreamSpecRaw filterStreamSpecRaw = (FilterStreamSpecRaw)stream;
                    FilterSpecRaw filterSpecRaw = filterStreamSpecRaw.getRawFilterSpec();
                    if (filterSpecRaw != null && filterSpecRaw.getFilterExpressions() != null) {
                        expressions.addAll(filterSpecRaw.getFilterExpressions());
                    }
                    if (filterSpecRaw != null && filterSpecRaw.getOptionalPropertyEvalSpec() != null) {
                        for (PropertyEvalAtom propertyEvalAtom : filterSpecRaw.getOptionalPropertyEvalSpec().getAtoms()) {
                            StatementSpecRawAnalyzer.addSelectClause(expressions, propertyEvalAtom.getOptionalSelectClause() == null ? null : propertyEvalAtom.getOptionalSelectClause().getSelectExprList());
                            if (propertyEvalAtom.getOptionalWhereClause() == null) continue;
                            expressions.add(propertyEvalAtom.getOptionalWhereClause());
                        }
                    }
                }
                if (stream instanceof PatternStreamSpecRaw) {
                    PatternStreamSpecRaw patternStreamSpecRaw = (PatternStreamSpecRaw)stream;
                    StatementSpecRawAnalyzer.collectPatternExpressions(expressions, patternStreamSpecRaw.getEvalFactoryNode());
                }
                if (stream instanceof MethodStreamSpec && (methodStreamSpec = (MethodStreamSpec)stream).getExpressions() != null) {
                    expressions.addAll(methodStreamSpec.getExpressions());
                }
                if (stream.getViewSpecs() == null) continue;
                for (ViewSpec viewSpec : stream.getViewSpecs()) {
                    expressions.addAll(viewSpec.getObjectParameters());
                }
            }
            if (raw.getOuterJoinDescList() != null) {
                for (OuterJoinDesc q : raw.getOuterJoinDescList()) {
                    if (q.getOptLeftNode() == null) continue;
                    expressions.add(q.getOptLeftNode());
                    expressions.add(q.getOptRightNode());
                    for (ExprIdentNode exprIdentNode : q.getAdditionalLeftNodes()) {
                        expressions.add(exprIdentNode);
                    }
                    for (ExprIdentNode exprIdentNode : q.getAdditionalRightNodes()) {
                        expressions.add(exprIdentNode);
                    }
                }
            }
        }
        if (raw.getFilterRootNode() != null) {
            expressions.add(raw.getFilterRootNode());
        }
        if (raw.getGroupByExpressions() != null) {
            expressions.addAll(raw.getGroupByExpressions());
        }
        if (raw.getHavingExprRootNode() != null) {
            expressions.add(raw.getHavingExprRootNode());
        }
        if (raw.getOutputLimitSpec() != null) {
            if (raw.getOutputLimitSpec().getWhenExpressionNode() != null) {
                expressions.add(raw.getOutputLimitSpec().getWhenExpressionNode());
            }
            if (raw.getOutputLimitSpec().getThenExpressions() != null) {
                for (OnTriggerSetAssignment thenAssign : raw.getOutputLimitSpec().getThenExpressions()) {
                    expressions.add(thenAssign.getExpression());
                }
            }
            if (raw.getOutputLimitSpec().getCrontabAtSchedule() != null) {
                expressions.addAll(raw.getOutputLimitSpec().getCrontabAtSchedule());
            }
            if (raw.getOutputLimitSpec().getTimePeriodExpr() != null) {
                expressions.add(raw.getOutputLimitSpec().getTimePeriodExpr());
            }
            if (raw.getOutputLimitSpec().getAfterTimePeriodExpr() != null) {
                expressions.add(raw.getOutputLimitSpec().getAfterTimePeriodExpr());
            }
        }
        if (raw.getOrderByList() != null) {
            for (OrderByItem orderByElement : raw.getOrderByList()) {
                expressions.add(orderByElement.getExprNode());
            }
        }
        if (raw.getMatchRecognizeSpec() != null) {
            if (raw.getMatchRecognizeSpec().getPartitionByExpressions() != null) {
                expressions.addAll(raw.getMatchRecognizeSpec().getPartitionByExpressions());
            }
            for (MatchRecognizeMeasureItem selectItemMR : raw.getMatchRecognizeSpec().getMeasures()) {
                expressions.add(selectItemMR.getExpr());
            }
            for (MatchRecognizeDefineItem define : raw.getMatchRecognizeSpec().getDefines()) {
                expressions.add(define.getExpression());
            }
            if (raw.getMatchRecognizeSpec().getInterval() != null && raw.getMatchRecognizeSpec().getInterval().getTimePeriodExpr() != null) {
                expressions.add(raw.getMatchRecognizeSpec().getInterval().getTimePeriodExpr());
            }
        }
        if (raw.getForClauseSpec() != null) {
            for (ForClauseItemSpec item : raw.getForClauseSpec().getClauses()) {
                if (item.getExpressions() == null) continue;
                expressions.addAll(item.getExpressions());
            }
        }
        return expressions;
    }

    private static void collectExpressions(List<ExprNode> expressions, ContextDetailCondition endpoint) {
        if (endpoint instanceof ContextDetailConditionCrontab) {
            ContextDetailConditionCrontab crontab = (ContextDetailConditionCrontab)endpoint;
            expressions.addAll(crontab.getCrontab());
        }
    }

    private static void addSelectClause(List<ExprNode> expressions, List<SelectClauseElementRaw> selectClause) {
        if (selectClause == null) {
            return;
        }
        for (SelectClauseElementRaw selement : selectClause) {
            if (!(selement instanceof SelectClauseExprRawSpec)) continue;
            SelectClauseExprRawSpec sexpr = (SelectClauseExprRawSpec)selement;
            expressions.add(sexpr.getSelectExpression());
        }
    }

    private static void collectPatternExpressions(List<ExprNode> expressions, EvalFactoryNode patternExpression) {
        EvalFilterFactoryNode filter;
        if (patternExpression instanceof EvalFilterFactoryNode && (filter = (EvalFilterFactoryNode)patternExpression).getRawFilterSpec().getFilterExpressions() != null) {
            expressions.addAll(filter.getRawFilterSpec().getFilterExpressions());
        }
        for (EvalFactoryNode child : patternExpression.getChildNodes()) {
            StatementSpecRawAnalyzer.collectPatternExpressions(expressions, child);
        }
    }
}

