/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.variable;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.VariableValueException;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.epl.variable.VariableServiceImpl;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.EventPropertyWriter;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VariableReadWritePackage {
    private static final Log log = LogFactory.getLog(VariableReadWritePackage.class);
    private final VariableTriggerSetDesc[] assignments;
    private final VariableReader[] readers;
    private final boolean[] mustCoerce;
    private final WriteDesc[] writers;
    private final Map<EventTypeSPI, EventBeanCopyMethod> copyMethods;
    private final EventAdapterService eventAdapterService;
    private final Map<String, Object> variableTypes;

    public VariableReadWritePackage(List<OnTriggerSetAssignment> assignments, VariableService variableService, EventAdapterService eventAdapterService) throws ExprValidationException {
        this.assignments = this.toAssignments(assignments);
        this.readers = new VariableReader[assignments.size()];
        this.mustCoerce = new boolean[assignments.size()];
        this.writers = new WriteDesc[assignments.size()];
        this.variableTypes = new HashMap<String, Object>();
        this.eventAdapterService = eventAdapterService;
        HashMap<EventTypeSPI, CopyMethodDesc> eventTypeWrittenProps = new HashMap<EventTypeSPI, CopyMethodDesc>();
        int count = 0;
        for (OnTriggerSetAssignment onTriggerSetAssignment : assignments) {
            VariableReader variableReader;
            String fullVariableName = onTriggerSetAssignment.getVariableName();
            String variableName = onTriggerSetAssignment.getVariableName();
            String subPropertyName = null;
            int indexOfDot = variableName.indexOf(46);
            if (indexOfDot != -1) {
                subPropertyName = variableName.substring(indexOfDot + 1, variableName.length());
                variableName = variableName.substring(0, indexOfDot);
            }
            this.readers[count] = variableReader = variableService.getReader(variableName);
            if (variableReader == null) {
                throw new ExprValidationException("Variable by name '" + variableName + "' has not been created or configured");
            }
            if (variableReader.isConstant()) {
                throw new ExprValidationException("Variable by name '" + variableName + "' is declared constant and may not be set");
            }
            if (subPropertyName != null) {
                if (variableReader.getEventType() == null) {
                    throw new ExprValidationException("Variable by name '" + variableName + "' does not have a property named '" + subPropertyName + "'");
                }
                EventType type = variableReader.getEventType();
                if (!(type instanceof EventTypeSPI)) {
                    throw new ExprValidationException("Variable by name '" + variableName + "' event type '" + type.getName() + "' not writable");
                }
                EventTypeSPI spi = (EventTypeSPI)type;
                EventPropertyWriter writer = spi.getWriter(subPropertyName);
                EventPropertyGetter getter = spi.getGetter(subPropertyName);
                if (writer == null) {
                    throw new ExprValidationException("Variable by name '" + variableName + "' the property '" + subPropertyName + "' is not writable");
                }
                this.variableTypes.put(fullVariableName, spi.getPropertyType(subPropertyName));
                CopyMethodDesc writtenProps = (CopyMethodDesc)eventTypeWrittenProps.get(spi);
                if (writtenProps == null) {
                    writtenProps = new CopyMethodDesc(variableName, new ArrayList<String>());
                    eventTypeWrittenProps.put(spi, writtenProps);
                }
                writtenProps.getPropertiesCopied().add(subPropertyName);
                this.writers[count] = new WriteDesc(spi, variableName, writer, getter);
            } else {
                Class expressionType = onTriggerSetAssignment.getExpression().getExprEvaluator().getType();
                if (variableReader.getEventType() != null) {
                    if (expressionType != null && !JavaClassHelper.isSubclassOrImplementsInterface(expressionType, variableReader.getEventType().getUnderlyingType())) {
                        throw new VariableValueException("Variable '" + variableName + "' of declared event type '" + variableReader.getEventType().getName() + "' underlying type '" + variableReader.getEventType().getUnderlyingType().getName() + "' cannot be assigned a value of type '" + expressionType.getName() + "'");
                    }
                    this.variableTypes.put(variableName, variableReader.getEventType().getUnderlyingType());
                } else {
                    Class variableType = variableReader.getType();
                    this.variableTypes.put(variableName, variableType);
                    if (variableType != Object.class && JavaClassHelper.getBoxedType(expressionType) != variableType && expressionType != null) {
                        if (!JavaClassHelper.isNumeric(variableType) || !JavaClassHelper.isNumeric(expressionType)) {
                            throw new ExprValidationException(VariableServiceImpl.getAssigmentExMessage(variableName, variableType, expressionType));
                        }
                        if (!JavaClassHelper.canCoerce(expressionType, variableType)) {
                            throw new ExprValidationException(VariableServiceImpl.getAssigmentExMessage(variableName, variableType, expressionType));
                        }
                        this.mustCoerce[count] = true;
                    }
                }
            }
            ++count;
        }
        if (eventTypeWrittenProps.isEmpty()) {
            this.copyMethods = Collections.EMPTY_MAP;
            return;
        }
        this.copyMethods = new HashMap<EventTypeSPI, EventBeanCopyMethod>();
        for (Map.Entry entry : eventTypeWrittenProps.entrySet()) {
            List<String> propsWritten = ((CopyMethodDesc)entry.getValue()).getPropertiesCopied();
            String[] props = propsWritten.toArray(new String[propsWritten.size()]);
            EventBeanCopyMethod copyMethod = ((EventTypeSPI)entry.getKey()).getCopyMethod(props);
            if (copyMethod == null) {
                throw new ExprValidationException("Variable '" + ((CopyMethodDesc)entry.getValue()).getVariableName() + "' of declared type " + JavaClassHelper.getClassNameFullyQualPretty(((EventTypeSPI)entry.getKey()).getUnderlyingType()) + "' cannot be assigned to");
            }
            this.copyMethods.put((EventTypeSPI)entry.getKey(), copyMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeVariables(VariableService variableService, EventBean[] eventsPerStream, Map<String, Object> valuesWritten, ExprEvaluatorContext exprEvaluatorContext) {
        HashSet<String> variablesBeansCopied = null;
        if (!this.copyMethods.isEmpty()) {
            variablesBeansCopied = new HashSet<String>();
        }
        variableService.getReadWriteLock().writeLock().lock();
        try {
            variableService.setLocalVersion();
            int count = 0;
            for (VariableTriggerSetDesc assignment : this.assignments) {
                VariableReader reader = this.readers[count];
                Object value = assignment.evaluator.evaluate(eventsPerStream, true, exprEvaluatorContext);
                if (this.writers[count] != null) {
                    EventBean current = (EventBean)reader.getValue();
                    if (current == null) {
                        value = null;
                    } else {
                        WriteDesc writeDesc = this.writers[count];
                        boolean copy = variablesBeansCopied.add(writeDesc.getVariableName());
                        if (copy) {
                            EventBean copied;
                            current = copied = this.copyMethods.get(writeDesc.getType()).copy(current);
                        }
                        variableService.write(reader.getVariableNumber(), current);
                        writeDesc.getWriter().write(value, current);
                    }
                } else if (reader.getEventType() != null) {
                    EventBean eventBean = this.eventAdapterService.adapterForType(value, reader.getEventType());
                    variableService.write(reader.getVariableNumber(), eventBean);
                } else {
                    if (value != null && this.mustCoerce[count]) {
                        value = JavaClassHelper.coerceBoxed((Number)value, reader.getType());
                    }
                    variableService.write(reader.getVariableNumber(), value);
                }
                ++count;
                if (valuesWritten == null) continue;
                valuesWritten.put(assignment.variableName, value);
            }
            variableService.commit();
        }
        catch (RuntimeException ex) {
            log.error((Object)("Error evaluating on-set variable expressions: " + ex.getMessage()), (Throwable)ex);
            variableService.rollback();
        }
        finally {
            variableService.getReadWriteLock().writeLock().unlock();
        }
    }

    public VariableReader[] getReaders() {
        return this.readers;
    }

    public Map<String, Object> getVariableTypes() {
        return this.variableTypes;
    }

    public Map<String, Object> iterate() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        int count = 0;
        for (VariableTriggerSetDesc assignment : this.assignments) {
            VariableReader reader = this.readers[count];
            Object value = reader.getValue();
            if (value == null) {
                values.put(assignment.variableName, null);
            } else if (this.writers[count] != null) {
                EventBean current = (EventBean)reader.getValue();
                values.put(assignment.variableName, this.writers[count].getGetter().get(current));
            } else if (value instanceof EventBean) {
                values.put(assignment.variableName, ((EventBean)value).getUnderlying());
            } else {
                values.put(assignment.variableName, value);
            }
            ++count;
        }
        return values;
    }

    private VariableTriggerSetDesc[] toAssignments(List<OnTriggerSetAssignment> assignments) {
        VariableTriggerSetDesc[] sets = new VariableTriggerSetDesc[assignments.size()];
        for (int i = 0; i < assignments.size(); ++i) {
            sets[i] = new VariableTriggerSetDesc(assignments.get(i).getVariableName(), assignments.get(i).getExpression().getExprEvaluator());
        }
        return sets;
    }

    private static class VariableTriggerSetDesc {
        private String variableName;
        private ExprEvaluator evaluator;

        public VariableTriggerSetDesc(String variableName, ExprEvaluator evaluator) {
            this.variableName = variableName;
            this.evaluator = evaluator;
        }
    }

    private static class WriteDesc {
        private final EventTypeSPI type;
        private final String variableName;
        private final EventPropertyWriter writer;
        private final EventPropertyGetter getter;

        public WriteDesc(EventTypeSPI type, String variableName, EventPropertyWriter writer, EventPropertyGetter getter) {
            this.type = type;
            this.variableName = variableName;
            this.writer = writer;
            this.getter = getter;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public EventPropertyWriter getWriter() {
            return this.writer;
        }

        public EventTypeSPI getType() {
            return this.type;
        }

        public EventPropertyGetter getGetter() {
            return this.getter;
        }
    }

    private static class CopyMethodDesc {
        private final String variableName;
        private final List<String> propertiesCopied;

        public CopyMethodDesc(String variableName, List<String> propertiesCopied) {
            this.variableName = variableName;
            this.propertiesCopied = propertiesCopied;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public List<String> getPropertiesCopied() {
            return this.propertiesCopied;
        }
    }
}

