/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.variable;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.variable.VariableVersionThreadEntry;
import com.espertech.esper.epl.variable.VariableVersionThreadLocal;
import com.espertech.esper.epl.variable.VersionedValueList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VariableReader {
    private static final Log log = LogFactory.getLog(VariableReader.class);
    private final String variableName;
    private final int variableNumber;
    private final VariableVersionThreadLocal versionThreadLocal;
    private volatile VersionedValueList<Object> versionsHigh;
    private volatile VersionedValueList<Object> versionsLow;
    private final Class type;
    private final EventType eventType;
    private final boolean constant;

    public VariableReader(VariableVersionThreadLocal versionThreadLocal, Class type, EventType eventType, String variableName, int variableNumber, VersionedValueList<Object> versions, boolean constant) {
        this.variableName = variableName;
        this.variableNumber = variableNumber;
        this.versionThreadLocal = versionThreadLocal;
        this.type = type;
        this.eventType = eventType;
        this.versionsLow = versions;
        this.versionsHigh = null;
        this.constant = constant;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public int getVariableNumber() {
        return this.variableNumber;
    }

    public Class getType() {
        return this.type;
    }

    public void setVersionsHigh(VersionedValueList<Object> versionsHigh) {
        this.versionsHigh = versionsHigh;
    }

    public void setVersionsLow(VersionedValueList<Object> versionsLow) {
        this.versionsLow = versionsLow;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Object getValue() {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        if (entry.getUncommitted() != null && entry.getUncommitted().containsKey(this.variableNumber)) {
            return entry.getUncommitted().get(this.variableNumber);
        }
        int myVersion = entry.getVersion();
        VersionedValueList<Object> versions = this.versionsLow;
        if (myVersion >= 2147383647 && this.versionsHigh != null) {
            versions = this.versionsHigh;
        }
        return versions.getVersion(myVersion);
    }

    public boolean isConstant() {
        return this.constant;
    }
}

