/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputConditionCount;
import com.espertech.esper.epl.view.OutputConditionFactory;

public final class OutputConditionCountFactory
implements OutputConditionFactory {
    private final long eventRate;
    private final VariableReader variableReader;

    public OutputConditionCountFactory(int eventRate, VariableReader variableReader) {
        if (eventRate < 1 && variableReader == null) {
            throw new IllegalArgumentException("Limiting output by event count requires an event count of at least 1 or a variable name");
        }
        this.eventRate = eventRate;
        this.variableReader = variableReader;
    }

    @Override
    public OutputCondition make(AgentInstanceContext agentInstanceContext, OutputCallback outputCallback) {
        return new OutputConditionCount(outputCallback, this);
    }

    public long getEventRate() {
        return this.eventRate;
    }

    public VariableReader getVariableReader() {
        return this.variableReader;
    }
}

