/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OutputConditionPolledCount
implements OutputConditionPolled {
    private long eventRate;
    private int newEventsCount;
    private int oldEventsCount;
    private final VariableReader variableReader;
    private boolean isFirst = true;
    private static final Log log = LogFactory.getLog(OutputConditionPolledCount.class);

    public OutputConditionPolledCount(int eventRate, VariableReader variableReader) {
        if (eventRate < 1 && variableReader == null) {
            throw new IllegalArgumentException("Limiting output by event count requires an event count of at least 1 or a variable name");
        }
        this.eventRate = eventRate;
        this.variableReader = variableReader;
        this.newEventsCount = eventRate;
        this.oldEventsCount = eventRate;
    }

    @Override
    public final boolean updateOutputCondition(int newDataCount, int oldDataCount) {
        Object value;
        if (this.variableReader != null && (value = this.variableReader.getValue()) != null) {
            this.eventRate = ((Number)value).longValue();
        }
        this.newEventsCount += newDataCount;
        this.oldEventsCount += oldDataCount;
        if (this.isSatisfied() || this.isFirst) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug((Object)".updateOutputCondition() condition satisfied");
            }
            this.isFirst = false;
            this.newEventsCount = 0;
            this.oldEventsCount = 0;
            return true;
        }
        return false;
    }

    public final String toString() {
        return this.getClass().getName() + " eventRate=" + this.eventRate;
    }

    private boolean isSatisfied() {
        return (long)this.newEventsCount >= this.eventRate || (long)this.oldEventsCount >= this.eventRate;
    }
}

