/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeIdentifierVisitor;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.variable.VariableReadWritePackage;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.event.EventAdapterService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputConditionPolledExpression
implements OutputConditionPolled {
    private static final Log log = LogFactory.getLog(OutputConditionPolledExpression.class);
    private final ExprEvaluator whenExpressionNode;
    private final AgentInstanceContext agentInstanceContext;
    private final VariableReadWritePackage variableReadWritePackage;
    private Map<String, Object> builtinProperties;
    private EventBean[] eventsPerStream;
    private EventType builtinPropertiesEventType;
    private int totalNewEventsCount;
    private int totalOldEventsCount;
    private int totalNewEventsSum;
    private int totalOldEventsSum;
    private Long lastOutputTimestamp;

    public OutputConditionPolledExpression(ExprNode whenExpressionNode, List<OnTriggerSetAssignment> assignments, AgentInstanceContext agentInstanceContext) throws ExprValidationException {
        this.whenExpressionNode = whenExpressionNode.getExprEvaluator();
        this.agentInstanceContext = agentInstanceContext;
        this.eventsPerStream = new EventBean[1];
        boolean containsBuiltinProperties = false;
        if (this.containsBuiltinProperties(whenExpressionNode)) {
            containsBuiltinProperties = true;
        } else if (assignments != null) {
            for (OnTriggerSetAssignment assignment : assignments) {
                if (!this.containsBuiltinProperties(assignment.getExpression())) continue;
                containsBuiltinProperties = true;
            }
        }
        if (containsBuiltinProperties) {
            this.builtinProperties = new HashMap<String, Object>();
            this.builtinPropertiesEventType = OutputConditionPolledExpression.getBuiltInEventType(agentInstanceContext.getStatementContext().getEventAdapterService());
            this.lastOutputTimestamp = agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        }
        this.variableReadWritePackage = assignments != null ? new VariableReadWritePackage(assignments, agentInstanceContext.getStatementContext().getVariableService(), agentInstanceContext.getStatementContext().getEventAdapterService()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateOutputCondition(int newEventsCount, int oldEventsCount) {
        this.totalNewEventsCount += newEventsCount;
        this.totalOldEventsCount += oldEventsCount;
        this.totalNewEventsSum += newEventsCount;
        this.totalOldEventsSum += oldEventsCount;
        boolean isOutput = this.evaluate();
        if (isOutput) {
            this.resetBuiltinProperties();
            if (this.variableReadWritePackage != null) {
                if (this.builtinProperties != null) {
                    this.populateBuiltinProperties();
                    this.eventsPerStream[0] = this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(this.builtinProperties, this.builtinPropertiesEventType);
                }
                this.variableReadWritePackage.writeVariables(this.agentInstanceContext.getStatementContext().getVariableService(), this.eventsPerStream, null, this.agentInstanceContext);
            }
        }
        return isOutput;
    }

    private void populateBuiltinProperties() {
        this.builtinProperties.put("count_insert", this.totalNewEventsCount);
        this.builtinProperties.put("count_remove", this.totalOldEventsCount);
        this.builtinProperties.put("count_insert_total", this.totalNewEventsSum);
        this.builtinProperties.put("count_remove_total", this.totalOldEventsSum);
        this.builtinProperties.put("last_output_timestamp", this.lastOutputTimestamp);
    }

    private boolean evaluate() {
        if (this.builtinProperties != null) {
            this.populateBuiltinProperties();
            this.eventsPerStream[0] = this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(this.builtinProperties, this.builtinPropertiesEventType);
        }
        boolean result = false;
        Boolean output = (Boolean)this.whenExpressionNode.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        if (output != null && output.booleanValue()) {
            result = true;
        }
        return result;
    }

    public static EventType getBuiltInEventType(EventAdapterService eventAdapterService) {
        HashMap<String, Object> outputLimitProperties = new HashMap<String, Object>();
        outputLimitProperties.put("count_insert", Integer.class);
        outputLimitProperties.put("count_remove", Integer.class);
        outputLimitProperties.put("last_output_timestamp", Long.class);
        return eventAdapterService.createAnonymousMapType(OutputConditionPolledExpression.class.getName(), outputLimitProperties);
    }

    private void resetBuiltinProperties() {
        if (this.builtinProperties != null) {
            this.totalNewEventsCount = 0;
            this.totalOldEventsCount = 0;
            this.lastOutputTimestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        }
    }

    private boolean containsBuiltinProperties(ExprNode expr) {
        ExprNodeIdentifierVisitor propertyVisitor = new ExprNodeIdentifierVisitor(false);
        expr.accept(propertyVisitor);
        return !propertyVisitor.getExprProperties().isEmpty();
    }
}

