/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.view.OutputConditionPolled;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OutputConditionPolledTime
implements OutputConditionPolled {
    private ExprTimePeriod timePeriod;
    private long msecIntervalSize;
    private AgentInstanceContext context;
    private long lastUpdate;
    private static final Log log = LogFactory.getLog(OutputConditionPolledTime.class);

    public OutputConditionPolledTime(ExprTimePeriod timePeriod, AgentInstanceContext context) {
        if (context == null) {
            String message = "OutputConditionTime requires a non-null view context";
            throw new NullPointerException(message);
        }
        this.context = context;
        this.timePeriod = timePeriod;
        Double numSeconds = (Double)timePeriod.evaluate(null, true, context);
        if (numSeconds == null) {
            throw new IllegalArgumentException("Output condition by time returned a null value for the interval size");
        }
        if (numSeconds < 0.001 && !timePeriod.hasVariable()) {
            throw new IllegalArgumentException("Output condition by time requires a interval size of at least 1 msec or a variable");
        }
        this.msecIntervalSize = Math.round(1000.0 * numSeconds);
        this.lastUpdate = -this.msecIntervalSize - 1L;
    }

    @Override
    public boolean updateOutputCondition(int newEventsCount, int oldEventsCount) {
        long current;
        Double numSeconds;
        if (this.timePeriod.hasVariable() && (numSeconds = (Double)this.timePeriod.evaluate(null, true, this.context)) != null) {
            long newMsecIntervalSize;
            this.msecIntervalSize = newMsecIntervalSize = Math.round(1000.0 * numSeconds);
        }
        if ((current = this.context.getTimeProvider().getTime()) - this.lastUpdate >= this.msecIntervalSize) {
            this.lastUpdate = current;
            return true;
        }
        return false;
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize;
    }
}

