/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputConditionBase;
import com.espertech.esper.epl.view.OutputConditionTimeFactory;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.StopCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OutputConditionTime
extends OutputConditionBase
implements OutputCondition,
StopCallback {
    private static final boolean DO_OUTPUT = true;
    private static final boolean FORCE_UPDATE = true;
    private final AgentInstanceContext context;
    private final OutputConditionTimeFactory parent;
    private final ScheduleSlot scheduleSlot;
    private long msecIntervalSize;
    private Long currentReferencePoint;
    private boolean isCallbackScheduled;
    private EPStatementHandleCallback handle;
    private static final Log log = LogFactory.getLog(OutputConditionTime.class);

    public OutputConditionTime(OutputCallback outputCallback, AgentInstanceContext context, OutputConditionTimeFactory outputConditionTimeFactory) {
        super(outputCallback);
        this.context = context;
        this.parent = outputConditionTimeFactory;
        this.scheduleSlot = context.getStatementContext().getScheduleBucket().allocateSlot();
        this.msecIntervalSize = this.parent.getMsecIntervalSize();
    }

    @Override
    public final void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        long newMsecIntervalSize;
        Double numSeconds;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".updateOutputCondition,   newEventsCount==" + newEventsCount + "  oldEventsCount==" + oldEventsCount));
        }
        if (this.currentReferencePoint == null) {
            this.currentReferencePoint = this.context.getStatementContext().getSchedulingService().getTime();
        }
        if (this.parent.getTimePeriod().hasVariable() && (numSeconds = (Double)this.parent.getTimePeriod().evaluate(null, true, this.context)) != null && (newMsecIntervalSize = Math.round(1000.0 * numSeconds)) != this.msecIntervalSize && this.isCallbackScheduled) {
            this.context.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
            this.scheduleCallback();
        }
        if (!this.isCallbackScheduled) {
            this.scheduleCallback();
        }
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize;
    }

    private void scheduleCallback() {
        Double param;
        if (this.parent.getTimePeriod().hasVariable() && (param = (Double)this.parent.getTimePeriod().evaluate(null, true, this.context)) != null) {
            this.msecIntervalSize = Math.round(1000.0 * param);
        }
        this.isCallbackScheduled = true;
        long current = this.context.getStatementContext().getSchedulingService().getTime();
        long afterMSec = OutputConditionTime.computeWaitMSec(current, this.currentReferencePoint, this.msecIntervalSize);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".scheduleCallback Scheduled new callback for  afterMsec=" + afterMSec + " now=" + current + " currentReferencePoint=" + this.currentReferencePoint + " msecIntervalSize=" + this.msecIntervalSize));
        }
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                OutputConditionTime.this.isCallbackScheduled = false;
                OutputConditionTime.this.outputCallback.continueOutputProcessing(true, true);
                OutputConditionTime.this.scheduleCallback();
            }
        };
        this.handle = new EPStatementHandleCallback(this.context.getEpStatementAgentInstanceHandle(), callback);
        this.context.getStatementContext().getSchedulingService().add(afterMSec, this.handle, this.scheduleSlot);
        this.context.addTerminationCallback(this);
    }

    @Override
    public void stop() {
        if (this.handle != null) {
            this.context.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    protected static long computeWaitMSec(long current, long reference, long interval) {
        long solution;
        long n = (long)((float)(current - reference) / ((float)interval * 1.0f));
        if (reference > current) {
            --n;
        }
        if ((solution = reference + (n + 1L) * interval - current) == 0L) {
            return interval;
        }
        return solution;
    }
}

