/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputProcessViewBaseWAfter;
import com.espertech.esper.epl.view.OutputProcessViewConditionFactory;
import com.espertech.esper.epl.view.OutputStrategyUtil;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputProcessViewConditionFirst
extends OutputProcessViewBaseWAfter {
    private final OutputProcessViewConditionFactory parent;
    private final OutputCondition outputCondition;
    private List<UniformPair<EventBean[]>> viewEventsList = new ArrayList<UniformPair<EventBean[]>>();
    private List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet = new ArrayList<UniformPair<Set<MultiKey<EventBean>>>>();
    private boolean witnessedFirst;
    private static final Log log = LogFactory.getLog(OutputProcessViewConditionFirst.class);

    public OutputProcessViewConditionFirst(ResultSetProcessor resultSetProcessor, Long afterConditionTime, Integer afterConditionNumberOfEvents, boolean afterConditionSatisfied, OutputProcessViewConditionFactory parent, AgentInstanceContext agentInstanceContext) {
        super(resultSetProcessor, afterConditionTime, afterConditionNumberOfEvents, afterConditionSatisfied);
        this.parent = parent;
        OutputCallback outputCallback = this.getCallbackToLocal(parent.getStreamCount());
        this.outputCondition = parent.getOutputConditionFactory().make(agentInstanceContext, outputCallback);
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length)));
        }
        if (!super.checkAfterCondition(newData, this.parent.getStatementContext())) {
            return;
        }
        if (!this.witnessedFirst) {
            boolean isGenerateSynthetic = this.parent.getStatementResultService().isMakeSynthetic();
            this.viewEventsList.add(new UniformPair<EventBean[]>(newData, oldData));
            UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processOutputLimitedView(this.viewEventsList, isGenerateSynthetic, OutputLimitLimitType.FIRST);
            this.viewEventsList.clear();
            if (newOldEvents == null || newOldEvents.getFirst() == null && newOldEvents.getSecond() == null) {
                return;
            }
            this.witnessedFirst = true;
            if (this.parent.isDistinct() && newOldEvents != null) {
                newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getEventBeanReader()));
                newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getEventBeanReader()));
            }
            boolean isGenerateNatural = this.parent.getStatementResultService().isMakeNatural();
            if (!isGenerateSynthetic && !isGenerateNatural) {
                if (AuditPath.isAuditEnabled) {
                    OutputStrategyUtil.indicateEarlyReturn(this.parent.getStatementContext(), newOldEvents);
                }
                return;
            }
            this.output(true, newOldEvents);
        } else {
            this.viewEventsList.add(new UniformPair<EventBean[]>(newData, oldData));
            this.resultSetProcessor.processOutputLimitedView(this.viewEventsList, false, OutputLimitLimitType.FIRST);
            this.viewEventsList.clear();
        }
        int newDataLength = 0;
        int oldDataLength = 0;
        if (newData != null) {
            newDataLength = newData.length;
        }
        if (oldData != null) {
            oldDataLength = oldData.length;
        }
        this.outputCondition.updateOutputCondition(newDataLength, oldDataLength);
    }

    @Override
    public void process(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        LinkedHashSet<Object> copyOld;
        LinkedHashSet<Object> copyNew;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".process Received update,   newData.length==" + (newEvents == null ? 0 : newEvents.size()) + "  oldData.length==" + (oldEvents == null ? 0 : oldEvents.size())));
        }
        if (!super.checkAfterCondition(newEvents, this.parent.getStatementContext())) {
            return;
        }
        if (!this.witnessedFirst) {
            copyNew = newEvents != null ? new LinkedHashSet<MultiKey<EventBean>>(newEvents) : new LinkedHashSet();
            copyOld = oldEvents != null ? new LinkedHashSet<MultiKey<EventBean>>(oldEvents) : new LinkedHashSet();
            this.joinEventsSet.add(new UniformPair(copyNew, copyOld));
            boolean isGenerateSynthetic = this.parent.getStatementResultService().isMakeSynthetic();
            UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processOutputLimitedJoin(this.joinEventsSet, isGenerateSynthetic, OutputLimitLimitType.FIRST);
            this.joinEventsSet.clear();
            if (newOldEvents == null || newOldEvents.getFirst() == null && newOldEvents.getSecond() == null) {
                return;
            }
            this.witnessedFirst = true;
            if (this.parent.isDistinct() && newOldEvents != null) {
                newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getEventBeanReader()));
                newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getEventBeanReader()));
            }
            boolean isGenerateNatural = this.parent.getStatementResultService().isMakeNatural();
            if (!isGenerateSynthetic && !isGenerateNatural) {
                if (AuditPath.isAuditEnabled) {
                    OutputStrategyUtil.indicateEarlyReturn(this.parent.getStatementContext(), newOldEvents);
                }
                return;
            }
            this.output(true, newOldEvents);
        } else {
            copyNew = newEvents != null ? new LinkedHashSet<MultiKey<EventBean>>(newEvents) : new LinkedHashSet();
            copyOld = oldEvents != null ? new LinkedHashSet<MultiKey<EventBean>>(oldEvents) : new LinkedHashSet();
            this.joinEventsSet.add(new UniformPair(copyNew, copyOld));
            this.resultSetProcessor.processOutputLimitedJoin(this.joinEventsSet, false, OutputLimitLimitType.FIRST);
            this.joinEventsSet.clear();
        }
        int newEventsSize = 0;
        if (newEvents != null) {
            newEventsSize = newEvents.size();
        }
        int oldEventsSize = 0;
        if (oldEvents != null) {
            oldEventsSize = oldEvents.size();
        }
        this.outputCondition.updateOutputCondition(newEventsSize, oldEventsSize);
    }

    protected void continueOutputProcessingView(boolean doOutput, boolean forceUpdate) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)".continueOutputProcessingView");
        }
        this.witnessedFirst = false;
    }

    private void output(boolean forceUpdate, UniformPair<EventBean[]> results) {
        if (this.childView != null) {
            OutputStrategyUtil.output(forceUpdate, results, this.childView);
        }
    }

    protected void continueOutputProcessingJoin(boolean doOutput, boolean forceUpdate) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)".continueOutputProcessingJoin");
        }
        this.witnessedFirst = false;
    }

    private OutputCallback getCallbackToLocal(int streamCount) {
        if (streamCount == 1) {
            return new OutputCallback(){

                @Override
                public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                    OutputProcessViewConditionFirst.this.continueOutputProcessingView(doOutput, forceUpdate);
                }
            };
        }
        return new OutputCallback(){

            @Override
            public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                OutputProcessViewConditionFirst.this.continueOutputProcessingJoin(doOutput, forceUpdate);
            }
        };
    }

    @Override
    public Iterator<EventBean> iterator() {
        return OutputStrategyUtil.getIterator(this.joinExecutionStrategy, this.resultSetProcessor, this.parentView, this.parent.isDistinct());
    }

    @Override
    public void terminated() {
        if (this.parent.isTerminable()) {
            this.outputCondition.terminated();
        }
    }
}

