/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.view.OutputProcessViewBase;
import com.espertech.esper.epl.view.OutputProcessViewDirect;
import com.espertech.esper.epl.view.OutputProcessViewDirectPostProcess;
import com.espertech.esper.epl.view.OutputProcessViewFactory;
import com.espertech.esper.epl.view.OutputStrategyPostProcess;
import com.espertech.esper.epl.view.OutputStrategyPostProcessFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputProcessViewDirectFactory
implements OutputProcessViewFactory {
    private static final Log log = LogFactory.getLog(OutputProcessViewDirectFactory.class);
    private final StatementContext statementContext;
    private final StatementResultService statementResultService;
    protected final OutputStrategyPostProcessFactory postProcessFactory;

    public OutputProcessViewDirectFactory(StatementContext statementContext, OutputStrategyPostProcessFactory postProcessFactory) {
        this.statementContext = statementContext;
        this.statementResultService = statementContext.getStatementResultService();
        this.postProcessFactory = postProcessFactory;
    }

    @Override
    public OutputProcessViewBase makeView(ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext) {
        if (this.postProcessFactory == null) {
            return new OutputProcessViewDirect(resultSetProcessor, this);
        }
        OutputStrategyPostProcess postProcess = this.postProcessFactory.make(agentInstanceContext);
        return new OutputProcessViewDirectPostProcess(resultSetProcessor, this, postProcess);
    }

    public StatementResultService getStatementResultService() {
        return this.statementResultService;
    }

    public StatementContext getStatementContext() {
        return this.statementContext;
    }
}

