/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.UpdateDispatchView;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.view.OutputStrategyPostProcessFactory;
import com.espertech.esper.event.NaturalEventBean;
import com.espertech.esper.util.AuditPath;

public class OutputStrategyPostProcess {
    private final OutputStrategyPostProcessFactory parent;
    private final AgentInstanceContext agentInstanceContext;
    private final boolean audit;

    public OutputStrategyPostProcess(OutputStrategyPostProcessFactory parent, AgentInstanceContext agentInstanceContext) {
        this.parent = parent;
        this.agentInstanceContext = agentInstanceContext;
        this.audit = AuditEnum.INSERT.getAudit(agentInstanceContext.getStatementContext().getAnnotations()) != null;
    }

    public void output(boolean forceUpdate, UniformPair<EventBean[]> result, UpdateDispatchView finalView) {
        EventBean[] oldEvents;
        EventBean[] newEvents = result != null ? result.getFirst() : null;
        EventBean[] eventBeanArray = oldEvents = result != null ? result.getSecond() : null;
        if (this.parent.isRoute()) {
            if (newEvents != null && this.parent.getInsertIntoStreamSelector().isSelectsIStream()) {
                this.route(newEvents, this.agentInstanceContext);
            }
            if (oldEvents != null && this.parent.getInsertIntoStreamSelector().isSelectsRStream()) {
                this.route(oldEvents, this.agentInstanceContext);
            }
        }
        if (this.parent.getSelectStreamDirEnum() == SelectClauseStreamSelectorEnum.RSTREAM_ONLY) {
            newEvents = oldEvents;
            oldEvents = null;
        } else if (this.parent.getSelectStreamDirEnum() == SelectClauseStreamSelectorEnum.ISTREAM_ONLY) {
            oldEvents = null;
        }
        if (newEvents != null || oldEvents != null) {
            finalView.newResult(new UniformPair<EventBean[]>(newEvents, oldEvents));
        } else if (forceUpdate) {
            finalView.newResult(new UniformPair<Object>(null, null));
        }
    }

    private void route(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        for (EventBean routed : events) {
            if (routed instanceof NaturalEventBean) {
                NaturalEventBean natural = (NaturalEventBean)routed;
                if (this.audit) {
                    AuditPath.auditInsertInto(this.agentInstanceContext.getEngineURI(), this.agentInstanceContext.getStatementName(), natural.getOptionalSynthetic());
                }
                this.parent.getInternalEventRouter().route(natural.getOptionalSynthetic(), this.parent.getEpStatementHandle(), this.agentInstanceContext.getStatementContext().getInternalEventEngineRouteDest(), exprEvaluatorContext, this.parent.isAddToFront());
                continue;
            }
            if (this.audit) {
                AuditPath.auditInsertInto(this.agentInstanceContext.getEngineURI(), this.agentInstanceContext.getStatementName(), routed);
            }
            this.parent.getInternalEventRouter().route(routed, this.parent.getEpStatementHandle(), this.agentInstanceContext.getStatementContext().getInternalEventEngineRouteDest(), exprEvaluatorContext, this.parent.isAddToFront());
        }
    }
}

