/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.ConfigurationEventTypeWithSupertype;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventPropertyGetterIndexed;
import com.espertech.esper.client.EventPropertyGetterMapped;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.epl.parse.ASTFilterSpecHelper;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeNestableGetterFactory;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.PropertySetDescriptor;
import com.espertech.esper.event.PropertySetDescriptorItem;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.MappedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.util.GraphUtil;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class BaseNestableEventType
implements EventTypeSPI {
    protected final EventTypeMetadata metadata;
    protected final String typeName;
    protected final EventAdapterService eventAdapterService;
    protected final EventType[] optionalSuperTypes;
    protected final Set<EventType> optionalDeepSupertypes;
    protected final int eventTypeId;
    protected final EventTypeNestableGetterFactory getterFactory;
    protected String[] propertyNames;
    protected EventPropertyDescriptor[] propertyDescriptors;
    protected final Map<String, PropertySetDescriptorItem> propertyItems;
    protected Map<String, EventPropertyGetter> propertyGetterCache;
    protected Map<String, Object> nestableTypes;
    protected String startTimestampPropertyName;
    protected String endTimestampPropertyName;

    protected abstract void postUpdateNestableTypes();

    public BaseNestableEventType(EventTypeMetadata metadata, String typeName, int eventTypeId, EventAdapterService eventAdapterService, Map<String, Object> propertyTypes, EventType[] optionalSuperTypes, Set<EventType> optionalDeepSupertypes, ConfigurationEventTypeWithSupertype typeConfig, EventTypeNestableGetterFactory getterFactory) {
        this.metadata = metadata;
        this.eventTypeId = eventTypeId;
        this.typeName = typeName;
        this.eventAdapterService = eventAdapterService;
        this.getterFactory = getterFactory;
        this.optionalSuperTypes = optionalSuperTypes;
        this.optionalDeepSupertypes = optionalDeepSupertypes == null ? Collections.emptySet() : optionalDeepSupertypes;
        PropertySetDescriptor propertySet = EventTypeUtility.getNestableProperties(propertyTypes, eventAdapterService, getterFactory, optionalSuperTypes);
        this.nestableTypes = propertySet.getNestableTypes();
        this.propertyNames = propertySet.getPropertyNameArray();
        this.propertyItems = propertySet.getPropertyItems();
        this.propertyDescriptors = propertySet.getPropertyDescriptors().toArray(new EventPropertyDescriptor[propertySet.getPropertyDescriptors().size()]);
        EventTypeUtility.TimestampPropertyDesc desc = EventTypeUtility.validatedDetermineTimestampProps(this, typeConfig == null ? null : typeConfig.getStartTimestampPropertyName(), typeConfig == null ? null : typeConfig.getEndTimestampPropertyName(), optionalSuperTypes);
        this.startTimestampPropertyName = desc.getStart();
        this.endTimestampPropertyName = desc.getEnd();
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    public int getEventTypeId() {
        return this.eventTypeId;
    }

    @Override
    public String getStartTimestampPropertyName() {
        return this.startTimestampPropertyName;
    }

    @Override
    public String getEndTimestampPropertyName() {
        return this.endTimestampPropertyName;
    }

    @Override
    public final Class getPropertyType(String propertyName) {
        return EventTypeUtility.getNestablePropertyType(propertyName, this.propertyItems, this.nestableTypes, this.eventAdapterService);
    }

    @Override
    public EventPropertyGetter getGetter(String propertyName) {
        if (this.propertyGetterCache == null) {
            this.propertyGetterCache = new HashMap<String, EventPropertyGetter>();
        }
        return EventTypeUtility.getNestableGetter(propertyName, this.propertyItems, this.propertyGetterCache, this.nestableTypes, this.eventAdapterService, this.getterFactory);
    }

    @Override
    public EventPropertyGetterMapped getGetterMapped(String mappedPropertyName) {
        PropertySetDescriptorItem item = this.propertyItems.get(mappedPropertyName);
        if (item == null || !item.getPropertyDescriptor().isMapped()) {
            return null;
        }
        MappedProperty mappedProperty = new MappedProperty(mappedPropertyName);
        return this.getterFactory.getPropertyProvidedGetterMap(this.nestableTypes, mappedPropertyName, mappedProperty, this.eventAdapterService);
    }

    @Override
    public EventPropertyGetterIndexed getGetterIndexed(String indexedPropertyName) {
        PropertySetDescriptorItem item = this.propertyItems.get(indexedPropertyName);
        if (item == null || !item.getPropertyDescriptor().isIndexed()) {
            return null;
        }
        IndexedProperty indexedProperty = new IndexedProperty(indexedPropertyName);
        return this.getterFactory.getPropertyProvidedGetterIndexed(this.nestableTypes, indexedPropertyName, indexedProperty, this.eventAdapterService);
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public boolean isProperty(String propertyName) {
        Class propertyType = this.getPropertyType(propertyName);
        if (propertyType == null && this.propertyItems.containsKey(ASTFilterSpecHelper.unescapeDot(propertyName))) {
            return true;
        }
        return propertyType != null;
    }

    @Override
    public EventType[] getSuperTypes() {
        return this.optionalSuperTypes;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return this.optionalDeepSupertypes.iterator();
    }

    public Map<String, Object> getTypes() {
        return this.nestableTypes;
    }

    public void addAdditionalProperties(Map<String, Object> typeMap, EventAdapterService eventAdapterService) {
        this.nestableTypes = GraphUtil.mergeNestableMap(this.nestableTypes, typeMap);
        this.postUpdateNestableTypes();
        PropertySetDescriptor propertySet = EventTypeUtility.getNestableProperties(typeMap, eventAdapterService, this.getterFactory, this.optionalSuperTypes);
        ArrayList<EventPropertyDescriptor> newPropertyDescriptors = new ArrayList<EventPropertyDescriptor>();
        for (EventPropertyDescriptor propertyDesc : propertySet.getPropertyDescriptors()) {
            if (this.propertyItems.containsKey(propertyDesc.getPropertyName())) continue;
            newPropertyDescriptors.add(propertyDesc);
        }
        ArrayList<String> newPropertyNames = new ArrayList<String>();
        for (String propertyName : propertySet.getPropertyNameList()) {
            if (this.propertyItems.containsKey(propertyName)) continue;
            newPropertyNames.add(propertyName);
            this.propertyItems.put(propertyName, propertySet.getPropertyItems().get(propertyName));
        }
        String[] allPropertyNames = new String[this.propertyNames.length + newPropertyNames.size()];
        System.arraycopy(this.propertyNames, 0, allPropertyNames, 0, this.propertyNames.length);
        int count = this.propertyNames.length;
        for (String newProperty : newPropertyNames) {
            allPropertyNames[count++] = newProperty;
        }
        this.propertyNames = allPropertyNames;
        EventPropertyDescriptor[] allPropertyDescriptors = new EventPropertyDescriptor[this.propertyDescriptors.length + newPropertyNames.size()];
        System.arraycopy(this.propertyDescriptors, 0, allPropertyDescriptors, 0, this.propertyDescriptors.length);
        count = this.propertyDescriptors.length;
        for (EventPropertyDescriptor desc : newPropertyDescriptors) {
            allPropertyDescriptors[count++] = desc;
        }
        this.propertyDescriptors = allPropertyDescriptors;
    }

    @Override
    public EventPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public static String isDeepEqualsProperties(String otherName, Map<String, Object> setOne, Map<String, Object> setTwo) {
        if (setOne.size() != setTwo.size()) {
            return "Type by name '" + otherName + "' expects " + setOne.size() + " properties but receives " + setTwo.size() + " properties";
        }
        for (Map.Entry<String, Object> entry : setOne.entrySet()) {
            String typeTwo;
            Object setTwoEventType;
            Class boxedThis;
            String propName = entry.getKey();
            Object setTwoType = setTwo.get(entry.getKey());
            boolean setTwoTypeFound = setTwo.containsKey(entry.getKey());
            Object setOneType = entry.getValue();
            if ((setOneType instanceof String || setOneType instanceof EventType) && setTwoType == null || (setTwoType instanceof String || setTwoType instanceof EventType) && setOneType == null) continue;
            if (!setTwoTypeFound) {
                return "The property '" + propName + "' is not provided but required";
            }
            if (setTwoType == null) continue;
            if (setOneType == null) {
                return "Type by name '" + otherName + "' in property '" + propName + "' incompatible with null-type or property name not found in target";
            }
            if (setTwoType instanceof Class && setOneType instanceof Class) {
                Class boxedOther = JavaClassHelper.getBoxedType((Class)setTwoType);
                if (boxedOther.equals(boxedThis = JavaClassHelper.getBoxedType((Class)setOneType)) || JavaClassHelper.isSubclassOrImplementsInterface(boxedOther, boxedThis)) continue;
                return "Type by name '" + otherName + "' in property '" + propName + "' expected " + boxedThis + " but receives " + boxedOther;
            }
            if (setTwoType instanceof BeanEventType && setOneType instanceof Class) {
                Class boxedOther = JavaClassHelper.getBoxedType(((BeanEventType)setTwoType).getUnderlyingType());
                if (boxedOther.equals(boxedThis = JavaClassHelper.getBoxedType((Class)setOneType))) continue;
                return "Type by name '" + otherName + "' in property '" + propName + "' expected " + boxedThis + " but receives " + boxedOther;
            }
            if (setTwoType instanceof EventType[] && ((EventType[])setTwoType)[0] instanceof BeanEventType && setOneType instanceof Class && ((Class)setOneType).isArray()) {
                Class boxedOther = JavaClassHelper.getBoxedType(((EventType[])setTwoType)[0].getUnderlyingType());
                if (boxedOther.equals(boxedThis = JavaClassHelper.getBoxedType(((Class)setOneType).getComponentType()))) continue;
                return "Type by name '" + otherName + "' in property '" + propName + "' expected " + boxedThis + " but receives " + boxedOther;
            }
            if (setTwoType instanceof Map && setOneType instanceof Map) {
                String messageIsDeepEquals = BaseNestableEventType.isDeepEqualsProperties(propName, (Map)setOneType, (Map)setTwoType);
                if (messageIsDeepEquals == null) continue;
                return messageIsDeepEquals;
            }
            if (setTwoType instanceof EventType && setOneType instanceof EventType) {
                boolean mismatch;
                if (setTwoType instanceof EventTypeSPI && setOneType instanceof EventTypeSPI) {
                    mismatch = !((EventTypeSPI)setOneType).equalsCompareType((EventTypeSPI)setTwoType);
                } else {
                    boolean bl = mismatch = !setOneType.equals(setTwoType);
                }
                if (!mismatch) continue;
                EventType setOneEventType = (EventType)setOneType;
                EventType setTwoEventType2 = (EventType)setTwoType;
                return "Type by name '" + otherName + "' in property '" + propName + "' expected event type '" + setOneEventType.getName() + "' but receives event type '" + setTwoEventType2.getName() + "'";
            }
            if (setTwoType instanceof String && setOneType instanceof EventType) {
                if (((EventType)setOneType).getName().equals(setTwoType)) continue;
                EventType setOneEventType = (EventType)setOneType;
                setTwoEventType = (String)setTwoType;
                return "Type by name '" + otherName + "' in property '" + propName + "' expected event type '" + setOneEventType.getName() + "' but receives event type '" + (String)setTwoEventType + "'";
            }
            if (setTwoType instanceof EventType && setOneType instanceof String) {
                if (((EventType)setTwoType).getName().equals(setOneType)) continue;
                String setOneEventType = (String)setOneType;
                setTwoEventType = (EventType)setTwoType;
                return "Type by name '" + otherName + "' in property '" + propName + "' expected event type '" + setOneEventType + "' but receives event type '" + setTwoEventType.getName() + "'";
            }
            if (setTwoType instanceof String && setOneType instanceof String) {
                if (setTwoType.equals(setOneType)) continue;
                String setOneEventType = (String)setOneType;
                setTwoEventType = (String)setTwoType;
                return "Type by name '" + otherName + "' in property '" + propName + "' expected event type '" + setOneEventType + "' but receives event type '" + (String)setTwoEventType + "'";
            }
            if (setTwoType instanceof EventType[] && setOneType instanceof String) {
                EventType[] setTwoTypeArr = (EventType[])setTwoType;
                EventType setTwoFragmentType = setTwoTypeArr[0];
                String setOneTypeString = (String)setOneType;
                if (!setOneTypeString.endsWith("[]")) {
                    return "Type by name '" + otherName + "' in property '" + propName + "' expected event type '" + setOneType + "' but receives event type '" + setTwoFragmentType.getName() + "[]'";
                }
                String setOneTypeNoArray = setOneTypeString.replaceAll("\\[\\]", "");
                if (setTwoFragmentType.getName().equals(setOneTypeNoArray)) continue;
                return "Type by name '" + otherName + "' in property '" + propName + "' expected event type '" + setOneTypeNoArray + "[]' but receives event type '" + setTwoFragmentType.getName() + "'";
            }
            String typeOne = BaseNestableEventType.getTypeName(setOneType);
            if (typeOne.equals(typeTwo = BaseNestableEventType.getTypeName(setTwoType))) continue;
            return "Type by name '" + otherName + "' in property '" + propName + "' expected " + typeOne + " but receives " + typeTwo;
        }
        return null;
    }

    private static String getTypeName(Object type) {
        Class boxedType;
        if (type == null) {
            return "null";
        }
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        if (type instanceof EventType) {
            return "event type '" + ((EventType)type).getName() + "'";
        }
        if (type instanceof String && (boxedType = JavaClassHelper.getBoxedType(JavaClassHelper.getPrimitiveClassForName((String)type))) != null) {
            return boxedType.getName();
        }
        return type.getClass().getName();
    }

    @Override
    public EventPropertyDescriptor getPropertyDescriptor(String propertyName) {
        PropertySetDescriptorItem item = this.propertyItems.get(propertyName);
        if (item == null) {
            return null;
        }
        return item.getPropertyDescriptor();
    }

    @Override
    public EventTypeMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public FragmentEventType getFragmentType(String propertyName) {
        PropertySetDescriptorItem item = this.propertyItems.get(propertyName);
        if (item != null) {
            return item.getFragmentEventType();
        }
        int index = ASTFilterSpecHelper.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            if (propertyName.endsWith("?")) {
                return null;
            }
            Property property = PropertyParser.parse(propertyName, false);
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = this.nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof EventType[]) {
                    EventType eventType = ((EventType[])type)[0];
                    return new FragmentEventType(eventType, false, false);
                }
                if (type instanceof String) {
                    String propTypeName = type.toString();
                    boolean isArray = EventTypeUtility.isPropertyArray(propTypeName);
                    if (!isArray) {
                        return null;
                    }
                    EventType innerType = this.eventAdapterService.getExistsTypeByName(propTypeName = EventTypeUtility.getPropertyRemoveArray(propTypeName));
                    if (!(innerType instanceof BaseNestableEventType)) {
                        return null;
                    }
                    return new FragmentEventType(innerType, false, false);
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                return EventBeanUtility.createNativeFragmentType(((Class)type).getComponentType(), null, this.eventAdapterService);
            }
            if (property instanceof MappedProperty) {
                return null;
            }
            return null;
        }
        String propertyMap = ASTFilterSpecHelper.unescapeDot(propertyName.substring(0, index));
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        if (propertyMap.endsWith("?")) {
            return null;
        }
        Object nestedType = this.nestableTypes.get(propertyMap);
        if (nestedType == null) {
            Property property = PropertyParser.parse(propertyMap, false);
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = this.nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof String) {
                    EventType innerType;
                    String propTypeName = type.toString();
                    boolean isArray = EventTypeUtility.isPropertyArray(propTypeName);
                    if (isArray) {
                        propTypeName = EventTypeUtility.getPropertyRemoveArray(propTypeName);
                    }
                    if (!((innerType = this.eventAdapterService.getExistsTypeByName(propTypeName)) instanceof BaseNestableEventType)) {
                        return null;
                    }
                    return innerType.getFragmentType(propertyNested);
                }
                if (type instanceof EventType[]) {
                    EventType innerType = ((EventType[])type)[0];
                    return innerType.getFragmentType(propertyNested);
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                FragmentEventType fragmentParent = EventBeanUtility.createNativeFragmentType((Class)type, null, this.eventAdapterService);
                if (fragmentParent == null) {
                    return null;
                }
                return fragmentParent.getFragmentType().getFragmentType(propertyNested);
            }
            if (property instanceof MappedProperty) {
                return null;
            }
            return null;
        }
        if (nestedType == Map.class) {
            return null;
        }
        if (nestedType instanceof Map) {
            return null;
        }
        if (nestedType instanceof Class) {
            Class simpleClass = (Class)nestedType;
            if (!JavaClassHelper.isFragmentableType(simpleClass)) {
                return null;
            }
            BeanEventType nestedEventType = this.eventAdapterService.getBeanEventTypeFactory().createBeanTypeDefaultName(simpleClass);
            return nestedEventType.getFragmentType(propertyNested);
        }
        if (nestedType instanceof EventType) {
            EventType innerType = (EventType)nestedType;
            return innerType.getFragmentType(propertyNested);
        }
        if (nestedType instanceof EventType[]) {
            EventType[] innerType = (EventType[])nestedType;
            return innerType[0].getFragmentType(propertyNested);
        }
        if (nestedType instanceof String) {
            EventType innerType;
            String nestedName = nestedType.toString();
            boolean isArray = EventTypeUtility.isPropertyArray(nestedName);
            if (isArray) {
                nestedName = EventTypeUtility.getPropertyRemoveArray(nestedName);
            }
            if (!((innerType = this.eventAdapterService.getExistsTypeByName(nestedName)) instanceof BaseNestableEventType)) {
                return null;
            }
            return innerType.getFragmentType(propertyNested);
        }
        String message = "Nestable map type configuration encountered an unexpected value type of '" + nestedType.getClass() + " for property '" + propertyName + "', expected Class, Map.class or Map<String, Object> as value type";
        throw new PropertyAccessException(message);
    }

    public String getEqualsMessage(EventType otherType) {
        if (!(otherType instanceof BaseNestableEventType)) {
            return "Type by name '" + otherType.getName() + "' is not a compatible type (target type underlying is '" + otherType.getUnderlyingType().getSimpleName() + "')";
        }
        BaseNestableEventType other = (BaseNestableEventType)otherType;
        if (this.metadata.getTypeClass() != EventTypeMetadata.TypeClass.ANONYMOUS && !other.typeName.equals(this.typeName)) {
            return "Type by name '" + otherType.getName() + "' is not the same name";
        }
        return BaseNestableEventType.isDeepEqualsProperties(otherType.getName(), other.nestableTypes, this.nestableTypes);
    }

    @Override
    public boolean equalsCompareType(EventType otherEventType) {
        if (this == otherEventType) {
            return true;
        }
        String message = this.getEqualsMessage(otherEventType);
        return message == null;
    }
}

