/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EventType;
import com.espertech.esper.event.EventTypeSPI;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;

public class EventAdapterServiceAnonymousTypeCache {
    private final int size;
    private final Deque<EventTypeSPI> recentTypes;

    public EventAdapterServiceAnonymousTypeCache(int size) {
        this.size = size;
        this.recentTypes = new ArrayDeque<EventTypeSPI>(size);
    }

    public EventType addReturnExistingAnonymousType(EventType requiredType) {
        if (!(requiredType instanceof EventTypeSPI)) {
            return requiredType;
        }
        for (EventTypeSPI existing : this.recentTypes) {
            if (existing.getClass() != requiredType.getClass() || !Arrays.equals(requiredType.getPropertyNames(), existing.getPropertyNames()) || !Arrays.equals(requiredType.getPropertyDescriptors(), existing.getPropertyDescriptors()) || !existing.equalsCompareType(requiredType)) continue;
            return existing;
        }
        if (this.recentTypes.size() == this.size && !this.recentTypes.isEmpty()) {
            this.recentTypes.removeFirst();
        }
        if (this.recentTypes.size() < this.size) {
            this.recentTypes.addLast((EventTypeSPI)requiredType);
        }
        return requiredType;
    }
}

