/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.arr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.arr.ObjectArrayEventPropertyGetter;

public class ObjectArrayFragmentArrayPropertyGetter
implements ObjectArrayEventPropertyGetter {
    private final int propertyIndex;
    private final EventType fragmentEventType;
    private final EventAdapterService eventAdapterService;

    public ObjectArrayFragmentArrayPropertyGetter(int propertyIndex, EventType fragmentEventType, EventAdapterService eventAdapterService) {
        this.propertyIndex = propertyIndex;
        this.fragmentEventType = fragmentEventType;
        this.eventAdapterService = eventAdapterService;
    }

    @Override
    public Object getObjectArray(Object[] array) throws PropertyAccessException {
        return array[this.propertyIndex];
    }

    @Override
    public boolean isObjectArrayExistsProperty(Object[] array) {
        return true;
    }

    @Override
    public Object get(EventBean obj) throws PropertyAccessException {
        Object[] array = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(obj);
        return this.getObjectArray(array);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        Object value = this.get(eventBean);
        return BaseNestableEventUtil.getFragmentArray(this.eventAdapterService, value, this.fragmentEventType);
    }
}

