/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.arr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.arr.ObjectArrayEventPropertyGetterAndMapped;

public class ObjectArrayMappedPropertyGetter
implements ObjectArrayEventPropertyGetterAndMapped {
    private final int propertyIndex;
    private final String key;

    public ObjectArrayMappedPropertyGetter(int propertyIndex, String key) {
        this.propertyIndex = propertyIndex;
        this.key = key;
    }

    @Override
    public Object getObjectArray(Object[] array) throws PropertyAccessException {
        return this.getObjectArrayInternal(array, this.key);
    }

    @Override
    public boolean isObjectArrayExistsProperty(Object[] array) {
        Object value = array[this.propertyIndex];
        return BaseNestableEventUtil.getMappedPropertyExists(value, this.key);
    }

    @Override
    public Object get(EventBean eventBean, String mapKey) throws PropertyAccessException {
        Object[] data = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return this.getObjectArrayInternal(data, mapKey);
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object[] data = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return this.getObjectArray(data);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Object[] data = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return this.isObjectArrayExistsProperty(data);
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        return null;
    }

    private Object getObjectArrayInternal(Object[] objectArray, String providedKey) throws PropertyAccessException {
        Object value = objectArray[this.propertyIndex];
        return BaseNestableEventUtil.getMappedPropertyValue(value, providedKey);
    }
}

