/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.DynamicPropertyDescriptor;
import com.espertech.esper.event.bean.DynamicPropertyGetterBase;
import com.espertech.esper.event.bean.PropertyHelper;
import com.espertech.esper.event.vaevent.PropertyUtility;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DynamicIndexedPropertyGetter
extends DynamicPropertyGetterBase {
    private final String getterMethodName;
    private final Object[] parameters;
    private final int index;

    public DynamicIndexedPropertyGetter(String fieldName, int index, EventAdapterService eventAdapterService) {
        super(eventAdapterService);
        this.getterMethodName = PropertyHelper.getGetterMethodName(fieldName);
        this.parameters = new Object[]{index};
        this.index = index;
    }

    @Override
    protected Method determineMethod(Class clazz) {
        try {
            return clazz.getMethod(this.getterMethodName, Integer.TYPE);
        }
        catch (NoSuchMethodException ex1) {
            Method method;
            try {
                method = clazz.getMethod(this.getterMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            if (!method.getReturnType().isArray()) {
                return null;
            }
            return method;
        }
    }

    @Override
    protected Object call(DynamicPropertyDescriptor descriptor, Object underlying) {
        try {
            if (descriptor.isHasParameters()) {
                return descriptor.getMethod().invoke(underlying, this.parameters);
            }
            Object array = descriptor.getMethod().invoke(underlying, null);
            if (array == null) {
                return null;
            }
            if (Array.getLength(array) <= this.index) {
                return null;
            }
            return Array.get(array, this.index);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(descriptor.getMethod().getJavaMethod(), underlying, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(descriptor.getMethod().getJavaMethod(), e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(descriptor.getMethod().getJavaMethod(), e);
        }
    }
}

