/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventPropertyGetterAndIndexed;
import com.espertech.esper.event.EventPropertyGetterAndMapped;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import com.espertech.esper.event.vaevent.PropertyUtility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class KeyedMethodPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter,
EventPropertyGetterAndMapped,
EventPropertyGetterAndIndexed {
    private final Method method;
    private final Object key;

    public KeyedMethodPropertyGetter(Method method, Object key, EventAdapterService eventAdapterService) {
        super(eventAdapterService, method.getReturnType(), null);
        this.key = key;
        this.method = method;
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        return this.getBeanPropInternal(eventBean.getUnderlying(), index);
    }

    @Override
    public Object get(EventBean eventBean, String mapKey) throws PropertyAccessException {
        return this.getBeanPropInternal(eventBean.getUnderlying(), mapKey);
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        return this.getBeanPropInternal(object, this.key);
    }

    private Object getBeanPropInternal(Object object, Object key) throws PropertyAccessException {
        try {
            return this.method.invoke(object, key);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(this.method, object, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(this.method, e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(this.method, e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(this.method, e);
        }
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    @Override
    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "KeyedMethodPropertyGetter  method=" + this.method.toString() + " key=" + this.key;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

