/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.vaevent;

import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.ConfigurationRevisionEventType;
import com.espertech.esper.client.ConfigurationVariantStream;
import com.espertech.esper.client.EventType;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeIdGenerator;
import com.espertech.esper.event.vaevent.PropertyUtility;
import com.espertech.esper.event.vaevent.RevisionSpec;
import com.espertech.esper.event.vaevent.VAERevisionProcessorBase;
import com.espertech.esper.event.vaevent.VAERevisionProcessorDeclared;
import com.espertech.esper.event.vaevent.VAERevisionProcessorMerge;
import com.espertech.esper.event.vaevent.VAEVariantProcessor;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.event.vaevent.ValueAddEventService;
import com.espertech.esper.event.vaevent.VariantSpec;
import com.espertech.esper.view.StatementStopService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;

public class ValueAddEventServiceImpl
implements ValueAddEventService {
    protected final Map<String, RevisionSpec> specificationsByRevisionName = new HashMap<String, RevisionSpec>();
    protected final Map<String, ValueAddEventProcessor> processorsByNamedWindow = new HashMap<String, ValueAddEventProcessor>();
    protected final Map<String, ValueAddEventProcessor> variantProcessors = new HashMap<String, ValueAddEventProcessor>();

    @Override
    public EventType[] getValueAddedTypes() {
        ArrayList<EventType> types = new ArrayList<EventType>();
        for (Map.Entry<String, ValueAddEventProcessor> revisionNamedWindow : this.processorsByNamedWindow.entrySet()) {
            types.add(revisionNamedWindow.getValue().getValueAddEventType());
        }
        for (Map.Entry<String, ValueAddEventProcessor> variantProcessor : this.variantProcessors.entrySet()) {
            types.add(variantProcessor.getValue().getValueAddEventType());
        }
        return types.toArray(new EventType[types.size()]);
    }

    @Override
    public void init(Map<String, ConfigurationRevisionEventType> configRevision, Map<String, ConfigurationVariantStream> configVariant, EventAdapterService eventAdapterService, EventTypeIdGenerator eventTypeIdGenerator) throws ConfigurationException {
        for (Map.Entry<String, ConfigurationRevisionEventType> entry : configRevision.entrySet()) {
            this.addRevisionEventType(entry.getKey(), entry.getValue(), eventAdapterService);
        }
        for (Map.Entry<String, Serializable> entry : configVariant.entrySet()) {
            this.addVariantStream(entry.getKey(), (ConfigurationVariantStream)entry.getValue(), eventAdapterService, eventTypeIdGenerator);
        }
    }

    @Override
    public void addRevisionEventType(String revisioneventTypeName, ConfigurationRevisionEventType config, EventAdapterService eventAdapterService) throws ConfigurationException {
        RevisionSpec specification = ValueAddEventServiceImpl.validateRevision(revisioneventTypeName, config, eventAdapterService);
        this.specificationsByRevisionName.put(revisioneventTypeName, specification);
    }

    @Override
    public void addVariantStream(String variantStreamname, ConfigurationVariantStream variantStreamConfig, EventAdapterService eventAdapterService, EventTypeIdGenerator eventTypeIdGenerator) throws ConfigurationException {
        VariantSpec variantSpec = ValueAddEventServiceImpl.validateVariantStream(variantStreamname, variantStreamConfig, eventAdapterService);
        VAEVariantProcessor processor = new VAEVariantProcessor(variantSpec, eventTypeIdGenerator, variantStreamConfig);
        eventAdapterService.addTypeByName(variantStreamname, processor.getValueAddEventType());
        this.variantProcessors.put(variantStreamname, processor);
    }

    public static VariantSpec validateVariantStream(String variantStreamname, ConfigurationVariantStream variantStreamConfig, EventAdapterService eventAdapterService) {
        if (variantStreamConfig.getTypeVariance() == ConfigurationVariantStream.TypeVariance.PREDEFINED && variantStreamConfig.getVariantTypeNames().isEmpty()) {
            throw new ConfigurationException("Invalid variant stream configuration, no event type name has been added and default type variance requires at least one type, for name '" + variantStreamname + "'");
        }
        LinkedHashSet<EventType> types = new LinkedHashSet<EventType>();
        for (String typeName : variantStreamConfig.getVariantTypeNames()) {
            EventType type = eventAdapterService.getExistsTypeByName(typeName);
            if (type == null) {
                throw new ConfigurationException("Event type by name '" + typeName + "' could not be found for use in variant stream configuration by name '" + variantStreamname + "'");
            }
            types.add(type);
        }
        EventType[] eventTypes = types.toArray(new EventType[types.size()]);
        return new VariantSpec(variantStreamname, eventTypes, variantStreamConfig.getTypeVariance());
    }

    @Override
    public EventType createRevisionType(String namedWindowName, String name, StatementStopService statementStopService, EventAdapterService eventAdapterService, EventTypeIdGenerator eventTypeIdGenerator) {
        RevisionSpec spec = this.specificationsByRevisionName.get(name);
        VAERevisionProcessorBase processor = spec.getPropertyRevision() == ConfigurationRevisionEventType.PropertyRevision.OVERLAY_DECLARED ? new VAERevisionProcessorDeclared(name, spec, statementStopService, eventAdapterService, eventTypeIdGenerator) : new VAERevisionProcessorMerge(name, spec, statementStopService, eventAdapterService, eventTypeIdGenerator);
        this.processorsByNamedWindow.put(namedWindowName, processor);
        return processor.getValueAddEventType();
    }

    @Override
    public ValueAddEventProcessor getValueAddProcessor(String name) {
        ValueAddEventProcessor proc = this.processorsByNamedWindow.get(name);
        if (proc != null) {
            return proc;
        }
        return this.variantProcessors.get(name);
    }

    @Override
    public EventType getValueAddUnderlyingType(String name) {
        RevisionSpec spec = this.specificationsByRevisionName.get(name);
        if (spec == null) {
            return null;
        }
        return spec.getBaseEventType();
    }

    @Override
    public boolean isRevisionTypeName(String revisionTypeName) {
        return this.specificationsByRevisionName.containsKey(revisionTypeName);
    }

    protected static RevisionSpec validateRevision(String revisioneventTypeName, ConfigurationRevisionEventType config, EventAdapterService eventAdapterService) throws ConfigurationException {
        String[] keyPropertyNames;
        if (config.getNameBaseEventTypes() == null || config.getNameBaseEventTypes().size() == 0) {
            throw new ConfigurationException("Required base event type name is not set in the configuration for revision event type '" + revisioneventTypeName + "'");
        }
        if (config.getNameBaseEventTypes().size() > 1) {
            throw new ConfigurationException("Only one base event type name may be added to revision event type '" + revisioneventTypeName + "', multiple base types are not yet supported");
        }
        String baseeventTypeName = config.getNameBaseEventTypes().iterator().next();
        EventType baseEventType = eventAdapterService.getExistsTypeByName(baseeventTypeName);
        if (baseEventType == null) {
            throw new ConfigurationException("Could not locate event type for name '" + baseeventTypeName + "' in the configuration for revision event type '" + revisioneventTypeName + "'");
        }
        EventType[] deltaTypes = new EventType[config.getNameDeltaEventTypes().size()];
        String[] deltaNames = new String[config.getNameDeltaEventTypes().size()];
        int count = 0;
        for (String deltaName : config.getNameDeltaEventTypes()) {
            EventType deltaEventType = eventAdapterService.getExistsTypeByName(deltaName);
            if (deltaEventType == null) {
                throw new ConfigurationException("Could not locate event type for name '" + deltaName + "' in the configuration for revision event type '" + revisioneventTypeName + "'");
            }
            deltaTypes[count] = deltaEventType;
            deltaNames[count] = deltaName;
            ++count;
        }
        if (config.getKeyPropertyNames() == null || config.getKeyPropertyNames().length == 0) {
            throw new ConfigurationException("Required key properties are not set in the configuration for revision event type '" + revisioneventTypeName + "'");
        }
        ValueAddEventServiceImpl.checkKeysExist(baseEventType, baseeventTypeName, config.getKeyPropertyNames(), revisioneventTypeName);
        for (int i = 0; i < deltaTypes.length; ++i) {
            ValueAddEventServiceImpl.checkKeysExist(deltaTypes[i], deltaNames[i], config.getKeyPropertyNames(), revisioneventTypeName);
        }
        for (String key : keyPropertyNames = PropertyUtility.copyAndSort(config.getKeyPropertyNames())) {
            Class typeProperty = baseEventType.getPropertyType(key);
            Object[] arr$ = deltaTypes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                EventType dtype = arr$[i$];
                Class dtypeProperty = dtype.getPropertyType(key);
                if (dtypeProperty == null || typeProperty == dtypeProperty) continue;
                throw new ConfigurationException("Key property named '" + key + "' does not have the same type for base and delta types of revision event type '" + revisioneventTypeName + "'");
            }
        }
        if (config.getPropertyRevision() == ConfigurationRevisionEventType.PropertyRevision.OVERLAY_DECLARED) {
            String[] nonkeyPropertyNames = PropertyUtility.uniqueExclusiveSort(baseEventType.getPropertyNames(), keyPropertyNames);
            HashSet<String> baseEventOnlyProperties = new HashSet<String>();
            HashSet<String> changesetPropertyNames = new HashSet<String>();
            for (String nonKey : nonkeyPropertyNames) {
                boolean overriddenProperty = false;
                for (EventType type : deltaTypes) {
                    if (!type.isProperty(nonKey)) continue;
                    changesetPropertyNames.add(nonKey);
                    overriddenProperty = true;
                    break;
                }
                if (overriddenProperty) continue;
                baseEventOnlyProperties.add(nonKey);
            }
            String[] changesetProperties = changesetPropertyNames.toArray(new String[changesetPropertyNames.size()]);
            String[] baseEventOnlyPropertyNames = baseEventOnlyProperties.toArray(new String[baseEventOnlyProperties.size()]);
            for (String changesetProperty : changesetProperties) {
                Class typeProperty = baseEventType.getPropertyType(changesetProperty);
                for (EventType dtype : deltaTypes) {
                    Class dtypeProperty = dtype.getPropertyType(changesetProperty);
                    if (dtypeProperty == null || typeProperty == dtypeProperty) continue;
                    throw new ConfigurationException("Property named '" + changesetProperty + "' does not have the same type for base and delta types of revision event type '" + revisioneventTypeName + "'");
                }
            }
            return new RevisionSpec(config.getPropertyRevision(), baseEventType, deltaTypes, deltaNames, keyPropertyNames, changesetProperties, baseEventOnlyPropertyNames, false, null);
        }
        HashSet<String> allProperties = new HashSet<String>();
        allProperties.addAll(Arrays.asList(baseEventType.getPropertyNames()));
        for (EventType deltaType : deltaTypes) {
            allProperties.addAll(Arrays.asList(deltaType.getPropertyNames()));
        }
        String[] allPropertiesArr = allProperties.toArray(new String[allProperties.size()]);
        String[] changesetProperties = PropertyUtility.uniqueExclusiveSort(allPropertiesArr, keyPropertyNames);
        boolean hasContributedByDelta = false;
        boolean[] contributedByDelta = new boolean[changesetProperties.length];
        count = 0;
        for (String property : changesetProperties) {
            Class basePropertyType = baseEventType.getPropertyType(property);
            Class typeTemp = null;
            if (basePropertyType != null) {
                typeTemp = basePropertyType;
            } else {
                hasContributedByDelta = true;
                contributedByDelta[count] = true;
            }
            for (EventType dtype : deltaTypes) {
                Class dtypeProperty = dtype.getPropertyType(property);
                if (dtypeProperty != null && typeTemp != null && dtypeProperty != typeTemp) {
                    throw new ConfigurationException("Property named '" + (String)property + "' does not have the same type for base and delta types of revision event type '" + revisioneventTypeName + "'");
                }
                typeTemp = dtypeProperty;
            }
            ++count;
        }
        return new RevisionSpec(config.getPropertyRevision(), baseEventType, deltaTypes, deltaNames, keyPropertyNames, changesetProperties, new String[0], hasContributedByDelta, contributedByDelta);
    }

    private static void checkKeysExist(EventType baseEventType, String name, String[] keyProperties, String revisioneventTypeName) {
        String[] propertyNames = baseEventType.getPropertyNames();
        for (String keyProperty : keyProperties) {
            boolean exists = false;
            for (String propertyName : propertyNames) {
                if (!propertyName.equals(keyProperty)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            throw new ConfigurationException("Key property '" + keyProperty + "' as defined in the configuration for revision event type '" + revisioneventTypeName + "' does not exists in event type '" + name + "'");
        }
    }
}

