/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterHandleSetNode;
import com.espertech.esper.filter.FilterParamIndexBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventTypeIndex
implements EventEvaluator {
    private Map<EventType, FilterHandleSetNode> eventTypes = new HashMap<EventType, FilterHandleSetNode>();
    private ReadWriteLock eventTypesRWLock = new ReentrantReadWriteLock();
    private static final Log log = LogFactory.getLog(EventTypeIndex.class);

    public void destroy() {
        this.eventTypes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EventType eventType, FilterHandleSetNode rootNode) {
        this.eventTypesRWLock.writeLock().lock();
        try {
            if (this.eventTypes.containsKey(eventType)) {
                throw new IllegalStateException("Event type already in index, add not performed, type=" + eventType);
            }
            this.eventTypes.put(eventType, rootNode);
        }
        finally {
            this.eventTypesRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeType(EventType type) {
        this.eventTypesRWLock.writeLock().lock();
        try {
            this.eventTypes.remove(type);
        }
        finally {
            this.eventTypesRWLock.writeLock().unlock();
        }
    }

    public FilterHandleSetNode get(EventType eventType) {
        this.eventTypesRWLock.readLock().lock();
        FilterHandleSetNode result = this.eventTypes.get(eventType);
        this.eventTypesRWLock.readLock().unlock();
        return result;
    }

    @Override
    public void matchEvent(EventBean theEvent, Collection<FilterHandle> matches) {
        EventType eventType = theEvent.getEventType();
        this.matchType(eventType, theEvent, matches);
        if (eventType.getSuperTypes() == null) {
            return;
        }
        Iterator<EventType> it = eventType.getDeepSuperTypes();
        while (it.hasNext()) {
            EventType superType = it.next();
            this.matchType(superType, theEvent, matches);
        }
    }

    protected int size() {
        return this.eventTypes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getFilterCountApprox() {
        int count = 0;
        this.eventTypesRWLock.readLock().lock();
        try {
            for (Map.Entry<EventType, FilterHandleSetNode> entry : this.eventTypes.entrySet()) {
                count += entry.getValue().getFilterCallbackCount();
                for (FilterParamIndexBase index : entry.getValue().getIndizes()) {
                    count += index.size();
                }
            }
        }
        finally {
            this.eventTypesRWLock.readLock().unlock();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchType(EventType eventType, EventBean eventBean, Collection<FilterHandle> matches) {
        this.eventTypesRWLock.readLock().lock();
        FilterHandleSetNode rootNode = null;
        try {
            rootNode = this.eventTypes.get(eventType);
        }
        finally {
            this.eventTypesRWLock.readLock().unlock();
        }
        if (rootNode == null) {
            return;
        }
        rootNode.matchEvent(eventBean, matches);
    }
}

