/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.filter.EventTypeIndex;
import com.espertech.esper.filter.EventTypeIndexBuilder;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterServiceListener;
import com.espertech.esper.filter.FilterServiceSPI;
import com.espertech.esper.filter.FilterSet;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.util.AuditPath;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilterServiceImpl
implements FilterServiceSPI {
    private static final Log log = LogFactory.getLog(FilterServiceImpl.class);
    private final EventTypeIndexBuilder indexBuilder;
    private final EventTypeIndex eventTypeIndex;
    private final AtomicLong numEventsEvaluated = new AtomicLong();
    private volatile long filtersVersion = 1L;
    private final CopyOnWriteArraySet<FilterServiceListener> filterServiceListeners;

    protected FilterServiceImpl() {
        this.eventTypeIndex = new EventTypeIndex();
        this.indexBuilder = new EventTypeIndexBuilder(this.eventTypeIndex);
        this.filterServiceListeners = new CopyOnWriteArraySet();
    }

    @Override
    public long getFiltersVersion() {
        return this.filtersVersion;
    }

    @Override
    public void destroy() {
        log.debug((Object)"Destroying filter service");
        this.eventTypeIndex.destroy();
        this.indexBuilder.destroy();
    }

    @Override
    public final void add(FilterValueSet filterValueSet, FilterHandle filterCallback) {
        this.indexBuilder.add(filterValueSet, filterCallback);
        ++this.filtersVersion;
    }

    @Override
    public final void remove(FilterHandle filterCallback) {
        this.indexBuilder.remove(filterCallback);
        ++this.filtersVersion;
    }

    @Override
    public final long evaluate(EventBean theEvent, Collection<FilterHandle> matches) {
        long version = this.filtersVersion;
        this.numEventsEvaluated.incrementAndGet();
        this.eventTypeIndex.matchEvent(theEvent, matches);
        if (AuditPath.isAuditEnabled && !this.filterServiceListeners.isEmpty()) {
            for (FilterServiceListener listener : this.filterServiceListeners) {
                listener.filtering(theEvent, matches, null);
            }
        }
        return version;
    }

    @Override
    public final long evaluate(EventBean theEvent, Collection<FilterHandle> matches, String statementId) {
        long version = this.filtersVersion;
        this.numEventsEvaluated.incrementAndGet();
        ArrayDeque<FilterHandle> allMatches = new ArrayDeque<FilterHandle>();
        this.eventTypeIndex.matchEvent(theEvent, allMatches);
        for (FilterHandle match : allMatches) {
            if (!match.getStatementId().equals(statementId)) continue;
            matches.add(match);
        }
        if (AuditPath.isAuditEnabled && !this.filterServiceListeners.isEmpty()) {
            for (FilterServiceListener listener : this.filterServiceListeners) {
                listener.filtering(theEvent, matches, statementId);
            }
        }
        return version;
    }

    @Override
    public final long getNumEventsEvaluated() {
        return this.numEventsEvaluated.get();
    }

    @Override
    public void resetStats() {
        this.numEventsEvaluated.set(0L);
    }

    @Override
    public void addFilterServiceListener(FilterServiceListener filterServiceListener) {
        this.filterServiceListeners.add(filterServiceListener);
    }

    @Override
    public void removeFilterServiceListener(FilterServiceListener filterServiceListener) {
        this.filterServiceListeners.remove(filterServiceListener);
    }

    @Override
    public FilterSet take(Set<String> statementIds) {
        ++this.filtersVersion;
        return this.indexBuilder.take(statementIds);
    }

    @Override
    public void apply(FilterSet filterSet) {
        ++this.filtersVersion;
        this.indexBuilder.apply(filterSet);
    }

    @Override
    public int getFilterCountApprox() {
        return this.eventTypeIndex.getFilterCountApprox();
    }

    @Override
    public int getCountTypes() {
        return this.eventTypeIndex.size();
    }

    @Override
    public void removeType(EventType type) {
        this.eventTypeIndex.removeType(type);
    }
}

