/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.property.PropertyEvaluator;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamComparator;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.filter.FilterValueSetImpl;
import com.espertech.esper.filter.FilterValueSetParam;
import com.espertech.esper.filter.FilterValueSetParamImpl;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class FilterSpecCompiled {
    private static final ArrayDeque<FilterSpecParam> EMPTY_LIST = new ArrayDeque();
    private static final FilterSpecParamComparator COMPARATOR_PARAMETERS = new FilterSpecParamComparator();
    private final EventType filterForEventType;
    private final String filterForEventTypeName;
    private final FilterSpecParam[] parameters;
    private final PropertyEvaluator optionalPropertyEvaluator;

    public FilterSpecCompiled(EventType eventType, String eventTypeName, List<FilterSpecParam> filterParameters, PropertyEvaluator optionalPropertyEvaluator) {
        this.filterForEventType = eventType;
        this.filterForEventTypeName = eventTypeName;
        this.parameters = FilterSpecCompiled.sortRemoveDups(filterParameters);
        this.optionalPropertyEvaluator = optionalPropertyEvaluator;
    }

    public final EventType getFilterForEventType() {
        return this.filterForEventType;
    }

    public final FilterSpecParam[] getParameters() {
        return this.parameters;
    }

    public String getFilterForEventTypeName() {
        return this.filterForEventTypeName;
    }

    public PropertyEvaluator getOptionalPropertyEvaluator() {
        return this.optionalPropertyEvaluator;
    }

    public EventType getResultEventType() {
        if (this.optionalPropertyEvaluator != null) {
            return this.optionalPropertyEvaluator.getFragmentEventType();
        }
        return this.filterForEventType;
    }

    public FilterValueSet getValueSet(MatchedEventMap matchedEvents, ExprEvaluatorContext evaluatorContext, FilterValueSetParam[] addendum) {
        FilterValueSetParam[] valueList;
        if (addendum != null) {
            valueList = new FilterValueSetParam[this.parameters.length + addendum.length];
            this.populateValueSet(valueList, matchedEvents, evaluatorContext);
            for (int i = 0; i < addendum.length; ++i) {
                valueList[i + this.parameters.length] = addendum[i];
            }
        } else {
            valueList = new FilterValueSetParam[this.parameters.length];
            this.populateValueSet(valueList, matchedEvents, evaluatorContext);
        }
        return new FilterValueSetImpl(this.filterForEventType, valueList);
    }

    private void populateValueSet(FilterValueSetParam[] valueList, MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext) {
        int count = 0;
        for (FilterSpecParam specParam : this.parameters) {
            Object filterForValue = specParam.getFilterValue(matchedEvents, exprEvaluatorContext);
            FilterValueSetParamImpl valueParam = new FilterValueSetParamImpl(specParam.getLookupable(), specParam.getFilterOperator(), filterForValue);
            valueList[count] = valueParam;
            ++count;
        }
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FilterSpecCompiled type=" + this.filterForEventType);
        buffer.append(" parameters=" + Arrays.toString(this.parameters));
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecCompiled)) {
            return false;
        }
        FilterSpecCompiled other = (FilterSpecCompiled)obj;
        if (!this.equalsTypeAndFilter(other)) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator == null) {
            return true;
        }
        if (this.optionalPropertyEvaluator != null && other.optionalPropertyEvaluator == null) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator != null) {
            return false;
        }
        return this.optionalPropertyEvaluator.compareTo(other.optionalPropertyEvaluator);
    }

    public boolean equalsTypeAndFilter(FilterSpecCompiled other) {
        if (this.filterForEventType != other.filterForEventType) {
            return false;
        }
        if (this.parameters.length != other.parameters.length) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i].equals(other.parameters[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.filterForEventType.hashCode();
        for (FilterSpecParam param : this.parameters) {
            hashCode ^= 31 * param.hashCode();
        }
        return hashCode;
    }

    protected static FilterSpecParam[] sortRemoveDups(List<FilterSpecParam> parameters) {
        if (parameters.isEmpty()) {
            return FilterSpecParam.EMPTY_PARAM_ARRAY;
        }
        if (parameters.size() == 1) {
            return new FilterSpecParam[]{parameters.get(0)};
        }
        ArrayDeque<FilterSpecParam> result = new ArrayDeque<FilterSpecParam>();
        TreeMap map = new TreeMap(COMPARATOR_PARAMETERS);
        for (FilterSpecParam filterSpecParam : parameters) {
            ArrayList<FilterSpecParam> list = (ArrayList<FilterSpecParam>)map.get((Object)filterSpecParam.getFilterOperator());
            if (list == null) {
                list = new ArrayList<FilterSpecParam>();
                map.put(filterSpecParam.getFilterOperator(), list);
            }
            boolean hasDuplicate = false;
            for (FilterSpecParam existing : list) {
                if (!existing.getLookupable().equals(filterSpecParam.getLookupable())) continue;
                hasDuplicate = true;
                break;
            }
            if (hasDuplicate) continue;
            list.add(filterSpecParam);
        }
        for (Map.Entry entry : map.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        return FilterSpecParam.toArray(result);
    }
}

