/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.util.SimpleNumberCoercer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilterSpecParamEventPropIndexed
extends FilterSpecParam {
    private static final Log log = LogFactory.getLog(FilterSpecParamEventPropIndexed.class);
    private final String resultEventAsName;
    private final int resultEventIndex;
    private final String resultEventProperty;
    private final boolean isMustCoerce;
    private final transient SimpleNumberCoercer numberCoercer;
    private final Class coercionType;
    private final String statementName;
    private static final long serialVersionUID = -1781904301744323795L;

    public FilterSpecParamEventPropIndexed(FilterSpecLookupable lookupable, FilterOperator filterOperator, String resultEventAsName, int resultEventIndex, String resultEventProperty, boolean isMustCoerce, SimpleNumberCoercer numberCoercer, Class coercionType, String statementName) throws IllegalArgumentException {
        super(lookupable, filterOperator);
        this.resultEventAsName = resultEventAsName;
        this.resultEventIndex = resultEventIndex;
        this.resultEventProperty = resultEventProperty;
        this.isMustCoerce = isMustCoerce;
        this.numberCoercer = numberCoercer;
        this.coercionType = coercionType;
        this.statementName = statementName;
        if (filterOperator.isRangeOperator()) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to " + "event property filter parameter");
        }
    }

    public boolean isMustCoerce() {
        return this.isMustCoerce;
    }

    public Class getCoercionType() {
        return this.coercionType;
    }

    public String getResultEventAsName() {
        return this.resultEventAsName;
    }

    public String getResultEventProperty() {
        return this.resultEventProperty;
    }

    @Override
    public Object getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext evaluatorContext) {
        EventBean[] events = (EventBean[])matchedEvents.getMatchingEventAsObjectByTag(this.resultEventAsName);
        Object value = null;
        if (events == null) {
            log.warn((Object)("Matching events for tag '" + this.resultEventAsName + "' returned a null result, using null value in filter criteria, for statement '" + this.statementName + "'"));
        } else if (this.resultEventIndex > events.length - 1) {
            log.warn((Object)("Matching events for tag '" + this.resultEventAsName + "' returned no result for index " + this.resultEventIndex + " at array length " + events.length + ", using null value in filter criteria, for statement '" + this.statementName + "'"));
        } else {
            value = events[this.resultEventIndex].get(this.resultEventProperty);
        }
        if (this.isMustCoerce) {
            value = this.numberCoercer.coerceBoxed((Number)value);
        }
        return value;
    }

    public int getResultEventIndex() {
        return this.resultEventIndex;
    }

    @Override
    public final String toString() {
        return super.toString() + " resultEventAsName=" + this.resultEventAsName + " resultEventProperty=" + this.resultEventProperty;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamEventPropIndexed)) {
            return false;
        }
        FilterSpecParamEventPropIndexed other = (FilterSpecParamEventPropIndexed)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.resultEventAsName.equals(other.resultEventAsName) && this.resultEventProperty.equals(other.resultEventProperty) && this.resultEventIndex == other.resultEventIndex;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.resultEventProperty.hashCode();
        return result;
    }
}

