/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeVariableVisitor;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.filter.ExprNodeAdapterBase;
import com.espertech.esper.filter.ExprNodeAdapterBaseStmtLock;
import com.espertech.esper.filter.ExprNodeAdapterBaseVariables;
import com.espertech.esper.filter.ExprNodeAdapterMultiStream;
import com.espertech.esper.filter.ExprNodeAdapterMultiStreamNoTL;
import com.espertech.esper.filter.ExprNodeAdapterMultiStreamNoTLStmtLock;
import com.espertech.esper.filter.ExprNodeAdapterMultiStreamStmtLock;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class FilterSpecParamExprNode
extends FilterSpecParam {
    private final String statementName;
    private final ExprNode exprNode;
    private final LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes;
    private final LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes;
    private final transient EventAdapterService eventAdapterService;
    private final transient VariableService variableService;
    private final boolean hasVariable;
    private final boolean useLargeThreadingProfile;
    private final boolean hasFilterStreamSubquery;
    private static final long serialVersionUID = 2298436088557677833L;

    public FilterSpecParamExprNode(FilterSpecLookupable lookupable, FilterOperator filterOperator, ExprNode exprNode, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, VariableService variableService, EventAdapterService eventAdapterService, ConfigurationInformation configurationInformation, String statementName, boolean hasSubquery) throws IllegalArgumentException {
        super(lookupable, filterOperator);
        if (filterOperator != FilterOperator.BOOLEAN_EXPRESSION) {
            throw new IllegalArgumentException("Invalid filter operator for filter expression node");
        }
        this.exprNode = exprNode;
        this.taggedEventTypes = taggedEventTypes;
        this.arrayEventTypes = arrayEventTypes;
        this.variableService = variableService;
        this.eventAdapterService = eventAdapterService;
        this.useLargeThreadingProfile = configurationInformation.getEngineDefaults().getExecution().getThreadingProfile() == ConfigurationEngineDefaults.ThreadingProfile.LARGE;
        this.statementName = statementName;
        this.hasFilterStreamSubquery = hasSubquery;
        ExprNodeVariableVisitor visitor = new ExprNodeVariableVisitor();
        exprNode.accept(visitor);
        this.hasVariable = visitor.isHasVariables();
    }

    public ExprNode getExprNode() {
        return this.exprNode;
    }

    public LinkedHashMap<String, Pair<EventType, String>> getTaggedEventTypes() {
        return this.taggedEventTypes;
    }

    @Override
    public final ExprNodeAdapterBase getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext) {
        VariableService variableServiceToUse;
        EventBean[] events = null;
        if (this.taggedEventTypes != null && !this.taggedEventTypes.isEmpty() || this.arrayEventTypes != null && !this.arrayEventTypes.isEmpty()) {
            int size = 0;
            size += this.taggedEventTypes != null ? this.taggedEventTypes.size() : 0;
            events = new EventBean[(size += this.arrayEventTypes != null ? this.arrayEventTypes.size() : 0) + 1];
            int count = 1;
            if (this.taggedEventTypes != null) {
                for (String string : this.taggedEventTypes.keySet()) {
                    events[count] = matchedEvents.getMatchingEventByTag(string);
                    ++count;
                }
            }
            if (this.arrayEventTypes != null) {
                for (Map.Entry entry : this.arrayEventTypes.entrySet()) {
                    EventType compositeEventType = (EventType)((Pair)entry.getValue()).getFirst();
                    events[count] = this.eventAdapterService.adapterForTypedMap(matchedEvents.getMatchingEventsAsMap(), compositeEventType);
                    ++count;
                }
            }
        }
        if (events == null) {
            if (this.hasFilterStreamSubquery) {
                return new ExprNodeAdapterBaseStmtLock(this.statementName, this.exprNode, exprEvaluatorContext, this.variableService);
            }
            if (!this.hasVariable) {
                return new ExprNodeAdapterBase(this.statementName, this.exprNode, exprEvaluatorContext);
            }
            return new ExprNodeAdapterBaseVariables(this.statementName, this.exprNode, exprEvaluatorContext, this.variableService);
        }
        VariableService variableService = variableServiceToUse = !this.hasVariable ? null : this.variableService;
        if (this.useLargeThreadingProfile) {
            if (this.hasFilterStreamSubquery) {
                return new ExprNodeAdapterMultiStreamNoTLStmtLock(this.statementName, this.exprNode, exprEvaluatorContext, variableServiceToUse, events);
            }
            return new ExprNodeAdapterMultiStreamNoTL(this.statementName, this.exprNode, exprEvaluatorContext, variableServiceToUse, events);
        }
        if (this.hasFilterStreamSubquery) {
            return new ExprNodeAdapterMultiStreamStmtLock(this.statementName, this.exprNode, exprEvaluatorContext, variableServiceToUse, events);
        }
        return new ExprNodeAdapterMultiStream(this.statementName, this.exprNode, exprEvaluatorContext, variableServiceToUse, events);
    }

    @Override
    public final String toString() {
        return super.toString() + "  exprNode=" + this.exprNode.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamExprNode)) {
            return false;
        }
        FilterSpecParamExprNode other = (FilterSpecParamExprNode)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.exprNode == other.exprNode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.exprNode.hashCode();
        return result;
    }
}

