/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexBase;
import com.espertech.esper.filter.FilterParamIndexBooleanExpr;
import com.espertech.esper.filter.FilterParamIndexCompare;
import com.espertech.esper.filter.FilterParamIndexCompareString;
import com.espertech.esper.filter.FilterParamIndexDoubleRange;
import com.espertech.esper.filter.FilterParamIndexDoubleRangeInverted;
import com.espertech.esper.filter.FilterParamIndexEquals;
import com.espertech.esper.filter.FilterParamIndexEqualsIs;
import com.espertech.esper.filter.FilterParamIndexIn;
import com.espertech.esper.filter.FilterParamIndexLookupableBase;
import com.espertech.esper.filter.FilterParamIndexNotEquals;
import com.espertech.esper.filter.FilterParamIndexNotEqualsIs;
import com.espertech.esper.filter.FilterParamIndexNotIn;
import com.espertech.esper.filter.FilterParamIndexStringRange;
import com.espertech.esper.filter.FilterParamIndexStringRangeInverted;
import com.espertech.esper.filter.FilterSpecLookupable;

public class IndexFactory {
    public static FilterParamIndexBase createIndex(FilterSpecLookupable lookupable, FilterOperator filterOperator) {
        Class returnValueType = lookupable.getReturnType();
        if (filterOperator == FilterOperator.EQUAL) {
            FilterParamIndexEquals index = new FilterParamIndexEquals(lookupable);
            return index;
        }
        if (filterOperator == FilterOperator.NOT_EQUAL) {
            FilterParamIndexNotEquals index = new FilterParamIndexNotEquals(lookupable);
            return index;
        }
        if (filterOperator == FilterOperator.IS) {
            FilterParamIndexEqualsIs index = new FilterParamIndexEqualsIs(lookupable);
            return index;
        }
        if (filterOperator == FilterOperator.IS_NOT) {
            FilterParamIndexNotEqualsIs index = new FilterParamIndexNotEqualsIs(lookupable);
            return index;
        }
        if (filterOperator == FilterOperator.GREATER || filterOperator == FilterOperator.GREATER_OR_EQUAL || filterOperator == FilterOperator.LESS || filterOperator == FilterOperator.LESS_OR_EQUAL) {
            FilterParamIndexLookupableBase index = returnValueType != String.class ? new FilterParamIndexCompare(lookupable, filterOperator) : new FilterParamIndexCompareString(lookupable, filterOperator);
            return index;
        }
        if (filterOperator.isRangeOperator()) {
            FilterParamIndexLookupableBase index = returnValueType != String.class ? new FilterParamIndexDoubleRange(lookupable, filterOperator) : new FilterParamIndexStringRange(lookupable, filterOperator);
            return index;
        }
        if (filterOperator.isInvertedRangeOperator()) {
            if (returnValueType != String.class) {
                return new FilterParamIndexDoubleRangeInverted(lookupable, filterOperator);
            }
            return new FilterParamIndexStringRangeInverted(lookupable, filterOperator);
        }
        if (filterOperator == FilterOperator.IN_LIST_OF_VALUES) {
            return new FilterParamIndexIn(lookupable);
        }
        if (filterOperator == FilterOperator.NOT_IN_LIST_OF_VALUES) {
            return new FilterParamIndexNotIn(lookupable);
        }
        if (filterOperator == FilterOperator.BOOLEAN_EXPRESSION) {
            return new FilterParamIndexBooleanExpr();
        }
        throw new IllegalArgumentException("Cannot create filter index instance for filter operator " + (Object)((Object)filterOperator));
    }
}

