/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.EventTypeIndexBuilderIndexLookupableIterator;
import com.espertech.esper.filter.EventTypeIndexBuilderIndexLookupablePair;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterHandleSetNode;
import com.espertech.esper.filter.FilterParamIndexBase;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.filter.FilterValueSetParam;
import com.espertech.esper.filter.IndexFactory;
import com.espertech.esper.filter.IndexHelper;
import com.espertech.esper.filter.IndexTreePath;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.ArrayDeque;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IndexTreeBuilder {
    private ArrayDeque<FilterValueSetParam> remainingParameters;
    private FilterHandle filterCallback;
    private long currentThreadId;
    private static final Log log = LogFactory.getLog(IndexTreeBuilder.class);

    public final IndexTreePath add(FilterValueSet filterValueSet, FilterHandle filterCallback, FilterHandleSetNode topNode) {
        this.remainingParameters = new ArrayDeque<FilterValueSetParam>(Arrays.asList(filterValueSet.getParameters()));
        this.filterCallback = filterCallback;
        this.currentThreadId = Thread.currentThread().getId();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".add (" + this.currentThreadId + ") Adding filter callback, " + "  topNode=" + topNode + "  filterCallback=" + this.filterCallback));
        }
        IndexTreePath treePathInfo = new IndexTreePath();
        this.addToNode(topNode, treePathInfo);
        this.remainingParameters = null;
        this.filterCallback = null;
        return treePathInfo;
    }

    public final void remove(EventType eventType, FilterHandle filterCallback, EventTypeIndexBuilderIndexLookupableIterator treePathInfo, FilterHandleSetNode topNode) {
        this.remainingParameters = null;
        this.filterCallback = filterCallback;
        this.currentThreadId = Thread.currentThread().getId();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".remove (" + this.currentThreadId + ") Removing filterCallback " + " type " + eventType.getName() + " from treepath=" + treePathInfo.toString() + "  topNode=" + topNode + "  filterCallback=" + filterCallback));
        }
        this.removeFromNode(topNode, treePathInfo);
        this.filterCallback = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToNode(FilterHandleSetNode currentNode, IndexTreePath treePathInfo) {
        Pair<FilterValueSetParam, FilterParamIndexBase> pair;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".addToNode (" + this.currentThreadId + ") Adding filterCallback, node=" + currentNode + "  remainingParameters=" + this.printRemainingParameters()));
        }
        if (this.remainingParameters.isEmpty()) {
            currentNode.getNodeRWLock().writeLock().lock();
            try {
                currentNode.add(this.filterCallback);
            }
            finally {
                currentNode.getNodeRWLock().writeLock().unlock();
            }
            return;
        }
        currentNode.getNodeRWLock().readLock().lock();
        try {
            pair = IndexHelper.findIndex(this.remainingParameters, currentNode.getIndizes());
            if (pair != null) {
                this.remainingParameters.remove(pair.getFirst());
                Object filterForValue = pair.getFirst().getFilterForValue();
                FilterParamIndexBase index = pair.getSecond();
                treePathInfo.add(index, filterForValue);
                this.addToIndex(index, filterForValue, treePathInfo);
                return;
            }
        }
        finally {
            currentNode.getNodeRWLock().readLock().unlock();
        }
        currentNode.getNodeRWLock().writeLock().lock();
        try {
            pair = IndexHelper.findIndex(this.remainingParameters, currentNode.getIndizes());
            if (pair != null) {
                this.remainingParameters.remove(pair.getFirst());
                Object filterForValue = pair.getFirst().getFilterForValue();
                FilterParamIndexBase index = pair.getSecond();
                treePathInfo.add(index, filterForValue);
                this.addToIndex(index, filterForValue, treePathInfo);
                return;
            }
            FilterValueSetParam parameterPickedForIndex = this.remainingParameters.removeFirst();
            FilterParamIndexBase index = IndexFactory.createIndex(parameterPickedForIndex.getLookupable(), parameterPickedForIndex.getFilterOperator());
            currentNode.getIndizes().add(index);
            treePathInfo.add(index, parameterPickedForIndex.getFilterForValue());
            this.addToIndex(index, parameterPickedForIndex.getFilterForValue(), treePathInfo);
        }
        finally {
            currentNode.getNodeRWLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFromNode(FilterHandleSetNode currentNode, EventTypeIndexBuilderIndexLookupableIterator treePathInfo) {
        EventTypeIndexBuilderIndexLookupablePair nextPair;
        EventTypeIndexBuilderIndexLookupablePair eventTypeIndexBuilderIndexLookupablePair = nextPair = treePathInfo.hasNext() ? treePathInfo.next() : null;
        if (nextPair == null) {
            currentNode.getNodeRWLock().writeLock().lock();
            try {
                boolean isRemoved = currentNode.remove(this.filterCallback);
                boolean isEmpty = currentNode.isEmpty();
                if (!isRemoved) {
                    log.warn((Object)(".removeFromNode (" + this.currentThreadId + ") Could not find the filterCallback to be removed within the supplied node , node=" + currentNode + "  filterCallback=" + this.filterCallback));
                }
                boolean bl = isEmpty;
                return bl;
            }
            finally {
                currentNode.getNodeRWLock().writeLock().unlock();
            }
        }
        FilterParamIndexBase nextIndex = nextPair.getIndex();
        Object filteredForValue = nextPair.getLookupable();
        currentNode.getNodeRWLock().writeLock().lock();
        try {
            boolean isRemoved;
            boolean isEmpty = this.removeFromIndex(nextIndex, treePathInfo, filteredForValue);
            if (!isEmpty) {
                boolean bl = false;
                return bl;
            }
            if (nextIndex.size() == 0 && !(isRemoved = currentNode.remove(nextIndex))) {
                log.warn((Object)(".removeFromNode (" + this.currentThreadId + ") Could not find the index in index list for removal, index=" + nextIndex.toString() + "  filterCallback=" + this.filterCallback));
                boolean bl = false;
                return bl;
            }
            boolean bl = currentNode.isEmpty();
            return bl;
        }
        finally {
            currentNode.getNodeRWLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFromIndex(FilterParamIndexBase index, EventTypeIndexBuilderIndexLookupableIterator treePathInfo, Object filterForValue) {
        index.getReadWriteLock().writeLock().lock();
        try {
            int size;
            EventTypeIndexBuilderIndexLookupablePair nextPair;
            EventEvaluator eventEvaluator = index.get(filterForValue);
            if (eventEvaluator == null) {
                log.warn((Object)(".removeFromIndex (" + this.currentThreadId + ") Could not find the filterCallback value in index, index=" + index.toString() + "  value=" + filterForValue.toString() + "  filterCallback=" + this.filterCallback));
                boolean bl = false;
                return bl;
            }
            if (eventEvaluator instanceof FilterHandleSetNode) {
                int size2;
                FilterHandleSetNode node = (FilterHandleSetNode)eventEvaluator;
                boolean isEmpty = this.removeFromNode(node, treePathInfo);
                if (isEmpty) {
                    index.remove(filterForValue);
                }
                boolean bl = (size2 = index.size()) == 0;
                return bl;
            }
            FilterParamIndexBase nextIndex = (FilterParamIndexBase)eventEvaluator;
            EventTypeIndexBuilderIndexLookupablePair eventTypeIndexBuilderIndexLookupablePair = nextPair = treePathInfo.hasNext() ? treePathInfo.next() : null;
            if (nextPair == null) {
                log.fatal((Object)(".removeFromIndex Expected an inner index to this index, this=" + this.toString()));
                assert (false);
                boolean size2 = false;
                return size2;
            }
            if (nextPair.getIndex() != nextIndex) {
                log.fatal((Object)(".removeFromIndex Expected an index for filterCallback that differs from the found index, this=" + this.toString() + "  expected=" + nextPair.getIndex()));
                assert (false);
                boolean size2 = false;
                return size2;
            }
            Object nextExpressionValue = nextPair.getLookupable();
            boolean isEmpty = this.removeFromIndex(nextPair.getIndex(), treePathInfo, nextExpressionValue);
            if (isEmpty) {
                index.remove(filterForValue);
            }
            boolean bl = (size = index.size()) == 0;
            return bl;
        }
        finally {
            index.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToIndex(FilterParamIndexBase index, Object filterForValue, IndexTreePath treePathInfo) {
        boolean added;
        EventEvaluator eventEvaluator;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".addToIndex (" + this.currentThreadId + ") Adding to index " + index.toString() + "  expressionValue=" + filterForValue));
        }
        index.getReadWriteLock().readLock().lock();
        try {
            eventEvaluator = index.get(filterForValue);
            if (eventEvaluator != null && (added = this.addToEvaluator(eventEvaluator, treePathInfo))) {
                return;
            }
        }
        finally {
            index.getReadWriteLock().readLock().unlock();
        }
        index.getReadWriteLock().writeLock().lock();
        try {
            eventEvaluator = index.get(filterForValue);
            if (eventEvaluator != null) {
                added = this.addToEvaluator(eventEvaluator, treePathInfo);
                if (added) {
                    return;
                }
                FilterParamIndexBase nextIndex = (FilterParamIndexBase)eventEvaluator;
                FilterHandleSetNode newNode = new FilterHandleSetNode();
                newNode.add(nextIndex);
                index.put(filterForValue, newNode);
                this.addToNode(newNode, treePathInfo);
                return;
            }
            if (this.remainingParameters.isEmpty()) {
                FilterHandleSetNode node = new FilterHandleSetNode();
                this.addToNode(node, treePathInfo);
                index.put(filterForValue, node);
                return;
            }
            FilterValueSetParam parameterPickedForIndex = this.remainingParameters.removeFirst();
            FilterParamIndexBase nextIndex = IndexFactory.createIndex(parameterPickedForIndex.getLookupable(), parameterPickedForIndex.getFilterOperator());
            index.put(filterForValue, nextIndex);
            treePathInfo.add(nextIndex, parameterPickedForIndex.getFilterForValue());
            this.addToIndex(nextIndex, parameterPickedForIndex.getFilterForValue(), treePathInfo);
        }
        finally {
            index.getReadWriteLock().writeLock().unlock();
        }
    }

    private boolean addToEvaluator(EventEvaluator eventEvaluator, IndexTreePath treePathInfo) {
        if (eventEvaluator instanceof FilterHandleSetNode) {
            FilterHandleSetNode node = (FilterHandleSetNode)eventEvaluator;
            this.addToNode(node, treePathInfo);
            return true;
        }
        FilterParamIndexBase nextIndex = (FilterParamIndexBase)eventEvaluator;
        FilterValueSetParam parameter = IndexHelper.findParameter(this.remainingParameters, nextIndex);
        if (parameter != null) {
            this.remainingParameters.remove(parameter);
            treePathInfo.add(nextIndex, parameter.getFilterForValue());
            this.addToIndex(nextIndex, parameter.getFilterForValue(), treePathInfo);
            return true;
        }
        return false;
    }

    private String printRemainingParameters() {
        StringBuilder buffer = new StringBuilder();
        int count = 0;
        for (FilterValueSetParam parameter : this.remainingParameters) {
            buffer.append("  param(").append(count).append(')');
            buffer.append(" property=").append(parameter.getLookupable());
            buffer.append(" operator=").append((Object)parameter.getFilterOperator());
            buffer.append(" value=").append(parameter.getFilterForValue());
            ++count;
        }
        return buffer.toString();
    }
}

