/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalAndNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvalAndStateNode
extends EvalStateNode
implements Evaluator {
    protected final EvalAndNode evalAndNode;
    protected final EvalStateNode[] activeChildNodes;
    protected Object[] eventsPerChild;
    private static final Log log = LogFactory.getLog(EvalAndStateNode.class);

    public EvalAndStateNode(Evaluator parentNode, EvalAndNode evalAndNode) {
        super(parentNode);
        this.evalAndNode = evalAndNode;
        this.activeChildNodes = new EvalStateNode[evalAndNode.getChildNodes().length];
        this.eventsPerChild = new Object[evalAndNode.getChildNodes().length];
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalAndNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        int count = 0;
        for (EvalNode node : this.evalAndNode.getChildNodes()) {
            EvalStateNode childState = node.newState(this, null, 0L);
            this.activeChildNodes[count++] = childState;
        }
        for (EvalStateNode child : this.activeChildNodes) {
            if (child == null) continue;
            child.start(beginState);
        }
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        Integer indexFrom = null;
        for (int i = 0; i < this.activeChildNodes.length; ++i) {
            if (this.activeChildNodes[i] != fromNode) continue;
            indexFrom = i;
        }
        if (isQuitted && indexFrom != null) {
            this.activeChildNodes[indexFrom.intValue()] = null;
        }
        if (this.eventsPerChild == null || indexFrom == null) {
            return;
        }
        EvalAndStateNode.addMatchEvent(this.eventsPerChild, indexFrom, matchEvent);
        boolean allHaveEvents = true;
        for (int i = 0; i < this.eventsPerChild.length; ++i) {
            if (this.eventsPerChild[i] != null) continue;
            allHaveEvents = false;
            break;
        }
        if (!allHaveEvents) {
            return;
        }
        List<MatchedEventMap> result = EvalAndStateNode.generateMatchEvents(matchEvent, this.eventsPerChild, indexFrom);
        boolean hasActive = false;
        for (int i = 0; i < this.activeChildNodes.length; ++i) {
            if (this.activeChildNodes[i] == null) continue;
            hasActive = true;
            break;
        }
        boolean quitted = true;
        if (hasActive) {
            for (EvalStateNode stateNode : this.activeChildNodes) {
                if (stateNode == null || stateNode.isNotOperator()) continue;
                quitted = false;
            }
        }
        if (quitted) {
            this.quit();
        }
        for (MatchedEventMap theEvent : result) {
            this.getParentEvaluator().evaluateTrue(theEvent, this, quitted);
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        Integer indexFrom = null;
        for (int i = 0; i < this.activeChildNodes.length; ++i) {
            if (this.activeChildNodes[i] != fromNode) continue;
            this.activeChildNodes[i] = null;
            indexFrom = i;
        }
        if (indexFrom != null) {
            this.eventsPerChild[indexFrom.intValue()] = null;
        }
        this.getParentEvaluator().evaluateFalse(this);
        this.quit();
    }

    public static List<MatchedEventMap> generateMatchEvents(MatchedEventMap matchEvent, Object[] eventsPerChild, int indexFrom) {
        ArrayList<List<MatchedEventMap>> listArray = new ArrayList<List<MatchedEventMap>>();
        int index = 0;
        for (int i = 0; i < eventsPerChild.length; ++i) {
            Object eventsChild = eventsPerChild[i];
            if (indexFrom == i || eventsChild == null) continue;
            if (eventsChild instanceof MatchedEventMap) {
                listArray.add(index++, Collections.singletonList((MatchedEventMap)eventsChild));
                continue;
            }
            listArray.add(index++, (List)eventsChild);
        }
        ArrayList<MatchedEventMap> results = new ArrayList<MatchedEventMap>();
        EvalAndStateNode.generateMatchEvents(listArray, 0, results, matchEvent);
        return results;
    }

    protected static void generateMatchEvents(ArrayList<List<MatchedEventMap>> eventList, int index, List<MatchedEventMap> result, MatchedEventMap matchEvent) {
        List<MatchedEventMap> events = eventList.get(index);
        for (MatchedEventMap theEvent : events) {
            MatchedEventMap current = matchEvent.shallowCopy();
            current.merge(theEvent);
            if (index + 1 == eventList.size()) {
                result.add(current);
                continue;
            }
            EvalAndStateNode.generateMatchEvents(eventList, index + 1, result, current);
        }
    }

    @Override
    public final void quit() {
        for (EvalStateNode child : this.activeChildNodes) {
            if (child == null) continue;
            child.quit();
        }
        Arrays.fill(this.activeChildNodes, null);
        this.eventsPerChild = null;
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode node : this.activeChildNodes) {
            if (node == null) continue;
            node.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvalAndStateNode";
    }

    public static void addMatchEvent(Object[] eventsPerChild, int indexFrom, MatchedEventMap matchEvent) {
        Object matchEventHolder = eventsPerChild[indexFrom];
        if (matchEventHolder == null) {
            eventsPerChild[indexFrom] = matchEvent;
        } else if (matchEventHolder instanceof MatchedEventMap) {
            ArrayList<MatchedEventMap> list = new ArrayList<MatchedEventMap>(4);
            list.add((MatchedEventMap)matchEventHolder);
            list.add(matchEvent);
            eventsPerChild[indexFrom] = list;
        } else {
            List list = (List)matchEventHolder;
            list.add(matchEvent);
        }
    }
}

