/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.pattern.EvalAuditNode;
import com.espertech.esper.pattern.EvalFilterNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNotNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeNumber;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalAuditStateNode
extends EvalStateNode
implements Evaluator {
    private final EvalAuditNode evalAuditNode;
    private EvalStateNode childState;
    private static final Log log = LogFactory.getLog(EvalAuditStateNode.class);

    public EvalAuditStateNode(Evaluator parentNode, EvalAuditNode evalAuditNode, EvalStateNodeNumber stateNodeNumber, long stateNodeId) {
        super(parentNode);
        this.evalAuditNode = evalAuditNode;
        this.childState = evalAuditNode.getChildNode().newState(this, stateNodeNumber, stateNodeId);
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalAuditNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        this.childState.start(beginState);
        this.evalAuditNode.getFactoryNode().increaseRefCount(this, this.evalAuditNode.getContext().getPatternContext());
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (this.evalAuditNode.getFactoryNode().isAuditPattern() && AuditPath.isInfoEnabled()) {
            String message = EvalAuditStateNode.toStringEvaluateTrue(this, this.evalAuditNode.getFactoryNode().getPatternExpr(), matchEvent, fromNode, isQuitted);
            AuditPath.auditLog(this.evalAuditNode.getContext().getStatementContext().getEngineURI(), this.evalAuditNode.getContext().getPatternContext().getStatementName(), AuditEnum.PATTERN, message);
        }
        this.getParentEvaluator().evaluateTrue(matchEvent, this, isQuitted);
        if (isQuitted) {
            this.evalAuditNode.getFactoryNode().decreaseRefCount(this, this.evalAuditNode.getContext().getPatternContext());
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        if (this.evalAuditNode.getFactoryNode().isAuditPattern() && AuditPath.isInfoEnabled()) {
            String message = this.toStringEvaluateFalse(this, this.evalAuditNode.getFactoryNode().getPatternExpr(), fromNode);
            AuditPath.auditLog(this.evalAuditNode.getContext().getStatementContext().getEngineURI(), this.evalAuditNode.getContext().getPatternContext().getStatementName(), AuditEnum.PATTERN, message);
        }
        this.getParentEvaluator().evaluateFalse(this);
    }

    @Override
    public final void quit() {
        if (this.childState != null) {
            this.childState.quit();
        }
        this.evalAuditNode.getFactoryNode().decreaseRefCount(this, this.evalAuditNode.getContext().getPatternContext());
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        if (this.childState != null) {
            this.childState.accept(visitor, data);
        }
        return data;
    }

    public EvalStateNode getChildState() {
        return this.childState;
    }

    public final String toString() {
        return "EvalAuditStateNode";
    }

    @Override
    public boolean isNotOperator() {
        EvalNode evalNode = this.evalAuditNode.getChildNode();
        return evalNode instanceof EvalNotNode;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return this.evalAuditNode.getFactoryNode().isFilterChildNonQuitting();
    }

    @Override
    public boolean isFilterStateNode() {
        return this.evalAuditNode.getChildNode() instanceof EvalFilterNode;
    }

    private static String toStringEvaluateTrue(EvalAuditStateNode current, String patternExpression, MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        StringWriter writer = new StringWriter();
        EvalAuditStateNode.writePatternExpr(current, patternExpression, writer);
        writer.write(" evaluate-true {");
        writer.write(" from: ");
        JavaClassHelper.writeInstance(writer, fromNode, false);
        writer.write(" map: {");
        String delimiter = "";
        Object[] data = matchEvent.getMatchingEvents();
        for (int i = 0; i < data.length; ++i) {
            String name = matchEvent.getMeta().getTagsPerIndex()[i];
            Object value = matchEvent.getMatchingEventAsObject(i);
            writer.write(delimiter);
            writer.write(name);
            writer.write("=");
            if (value instanceof EventBean) {
                writer.write(((EventBean)value).getUnderlying().toString());
            } else if (value instanceof EventBean[]) {
                writer.write(EventBeanUtility.summarize((EventBean[])value));
            }
            delimiter = ", ";
        }
        writer.write("} quitted: ");
        writer.write(Boolean.toString(isQuitted));
        writer.write("}");
        return writer.toString();
    }

    private String toStringEvaluateFalse(EvalAuditStateNode current, String patternExpression, EvalStateNode fromNode) {
        StringWriter writer = new StringWriter();
        EvalAuditStateNode.writePatternExpr(current, patternExpression, writer);
        writer.write(" evaluate-false {");
        writer.write(" from ");
        JavaClassHelper.writeInstance(writer, fromNode, false);
        writer.write("}");
        return writer.toString();
    }

    protected static void writePatternExpr(EvalAuditStateNode current, String patternExpression, StringWriter writer) {
        if (patternExpression != null) {
            writer.write(40);
            writer.write(patternExpression);
            writer.write(41);
        } else {
            JavaClassHelper.writeInstance(writer, "subexr", current);
        }
    }
}

