/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.epl.spec.FilterSpecRaw;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.pattern.EvalFilterNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNodeFactoryBase;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvalFilterFactoryNode
extends EvalNodeFactoryBase {
    private static final long serialVersionUID = 0L;
    private final FilterSpecRaw rawFilterSpec;
    private final String eventAsName;
    private transient FilterSpecCompiled filterSpec;
    private final Integer consumptionLevel;
    private int eventAsTagNumber = -1;
    private static final Log log = LogFactory.getLog(EvalFilterFactoryNode.class);

    protected EvalFilterFactoryNode(FilterSpecRaw filterSpecification, String eventAsName, Integer consumptionLevel) {
        this.rawFilterSpec = filterSpecification;
        this.eventAsName = eventAsName;
        this.consumptionLevel = consumptionLevel;
    }

    @Override
    public EvalNode makeEvalNode(PatternAgentInstanceContext agentInstanceContext) {
        return new EvalFilterNode(agentInstanceContext, this);
    }

    public FilterSpecRaw getRawFilterSpec() {
        return this.rawFilterSpec;
    }

    public final FilterSpecCompiled getFilterSpec() {
        return this.filterSpec;
    }

    public void setFilterSpec(FilterSpecCompiled filterSpec) {
        this.filterSpec = filterSpec;
    }

    public final String getEventAsName() {
        return this.eventAsName;
    }

    public Integer getConsumptionLevel() {
        return this.consumptionLevel;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("EvalFilterNode rawFilterSpec=" + this.rawFilterSpec);
        buffer.append(" filterSpec=" + this.filterSpec);
        buffer.append(" eventAsName=" + this.eventAsName);
        return buffer.toString();
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    public int getEventAsTagNumber() {
        return this.eventAsTagNumber;
    }

    public void setEventAsTagNumber(int eventAsTagNumber) {
        this.eventAsTagNumber = eventAsTagNumber;
    }

    @Override
    public boolean isStateful() {
        return false;
    }
}

