/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.hook.ConditionPatternSubexpressionMax;
import com.espertech.esper.pattern.EvalFollowedByNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.pool.PatternSubexpressionPoolStmtSvc;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvalFollowedByWithMaxStateNodeManaged
extends EvalStateNode
implements Evaluator {
    protected final EvalFollowedByNode evalFollowedByNode;
    protected final HashMap<EvalStateNode, Integer> nodes;
    protected final int[] countActivePerChild;
    private static final Log log = LogFactory.getLog(EvalFollowedByWithMaxStateNodeManaged.class);

    public EvalFollowedByWithMaxStateNodeManaged(Evaluator parentNode, EvalFollowedByNode evalFollowedByNode) {
        super(parentNode);
        this.evalFollowedByNode = evalFollowedByNode;
        this.nodes = new HashMap();
        this.countActivePerChild = (int[])(evalFollowedByNode.isTrackWithMax() ? new int[evalFollowedByNode.getChildNodes().length - 1] : null);
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalFollowedByNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        EvalNode child = this.evalFollowedByNode.getChildNodes()[0];
        EvalStateNode childState = child.newState(this, null, 0L);
        this.nodes.put(childState, 0);
        childState.start(beginState);
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        Integer index = this.nodes.get(fromNode);
        if (isQuitted) {
            this.nodes.remove(fromNode);
            if (index != null && index > 0) {
                if (this.evalFollowedByNode.isTrackWithMax()) {
                    int n = index - 1;
                    this.countActivePerChild[n] = this.countActivePerChild[n] - 1;
                }
                if (this.evalFollowedByNode.isTrackWithPool()) {
                    PatternSubexpressionPoolStmtSvc poolSvc = this.evalFollowedByNode.getContext().getStatementContext().getPatternSubexpressionPoolSvc();
                    poolSvc.getEngineSvc().decreaseCount(this.evalFollowedByNode);
                    poolSvc.getStmtHandler().decreaseCount();
                }
            }
        }
        if (index == null) {
            return;
        }
        int numChildNodes = this.evalFollowedByNode.getChildNodes().length;
        if (index == numChildNodes - 1) {
            boolean isFollowedByQuitted = false;
            if (this.nodes.isEmpty()) {
                isFollowedByQuitted = true;
            }
            this.getParentEvaluator().evaluateTrue(matchEvent, this, isFollowedByQuitted);
        } else {
            int max;
            if (this.evalFollowedByNode.isTrackWithMax() && (max = this.evalFollowedByNode.getFactoryNode().getMax(index)) != -1 && max >= 0 && this.countActivePerChild[index] >= max) {
                this.evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext().getExceptionHandlingService().handleCondition(new ConditionPatternSubexpressionMax(max), this.evalFollowedByNode.getContext().getAgentInstanceContext().getStatementContext().getEpStatementHandle());
                return;
            }
            if (this.evalFollowedByNode.isTrackWithPool()) {
                PatternSubexpressionPoolStmtSvc poolSvc = this.evalFollowedByNode.getContext().getStatementContext().getPatternSubexpressionPoolSvc();
                boolean allow = poolSvc.getEngineSvc().tryIncreaseCount(this.evalFollowedByNode);
                if (!allow) {
                    return;
                }
                poolSvc.getStmtHandler().increaseCount();
            }
            if (this.evalFollowedByNode.isTrackWithMax()) {
                int n = index;
                this.countActivePerChild[n] = this.countActivePerChild[n] + 1;
            }
            EvalNode child = this.evalFollowedByNode.getChildNodes()[index + 1];
            EvalStateNode childState = child.newState(this, null, 0L);
            this.nodes.put(childState, index + 1);
            childState.start(matchEvent);
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        fromNode.quit();
        Integer index = this.nodes.remove(fromNode);
        if (index != null && index > 0) {
            if (this.evalFollowedByNode.isTrackWithMax()) {
                int n = index - 1;
                this.countActivePerChild[n] = this.countActivePerChild[n] - 1;
            }
            if (this.evalFollowedByNode.isTrackWithPool()) {
                PatternSubexpressionPoolStmtSvc poolSvc = this.evalFollowedByNode.getContext().getStatementContext().getPatternSubexpressionPoolSvc();
                poolSvc.getEngineSvc().decreaseCount(this.evalFollowedByNode);
                poolSvc.getStmtHandler().decreaseCount();
            }
        }
        if (this.nodes.isEmpty()) {
            this.getParentEvaluator().evaluateFalse(this);
            this.quit();
        }
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public final void quit() {
        for (Map.Entry<EvalStateNode, Integer> entry : this.nodes.entrySet()) {
            entry.getKey().quit();
            if (!this.evalFollowedByNode.isTrackWithPool() || entry.getValue() <= 0) continue;
            PatternSubexpressionPoolStmtSvc poolSvc = this.evalFollowedByNode.getContext().getStatementContext().getPatternSubexpressionPoolSvc();
            poolSvc.getEngineSvc().decreaseCount(this.evalFollowedByNode);
            poolSvc.getStmtHandler().decreaseCount();
        }
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode node : this.nodes.keySet()) {
            node.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvalFollowedByStateNode nodes=" + this.nodes.size();
    }
}

