/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.pattern.EvalMatchUntilNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvalMatchUntilStateNode
extends EvalStateNode
implements Evaluator {
    protected final EvalMatchUntilNode evalMatchUntilNode;
    protected MatchedEventMap beginState;
    protected final ArrayList<EventBean>[] matchedEventArrays;
    protected EvalStateNode stateMatcher;
    protected EvalStateNode stateUntil;
    protected int numMatches;
    protected Integer lowerbounds;
    protected Integer upperbounds;
    private static final Log log = LogFactory.getLog(EvalMatchUntilStateNode.class);

    public EvalMatchUntilStateNode(Evaluator parentNode, EvalMatchUntilNode evalMatchUntilNode) {
        super(parentNode);
        this.matchedEventArrays = new ArrayList[evalMatchUntilNode.getFactoryNode().getTagsArrayed().length];
        this.evalMatchUntilNode = evalMatchUntilNode;
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalMatchUntilNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        this.beginState = beginState;
        EvalNode childMatcher = this.evalMatchUntilNode.getChildNodeSub();
        this.stateMatcher = childMatcher.newState(this, null, 0L);
        if (this.evalMatchUntilNode.getChildNodeUntil() != null) {
            EvalNode childUntil = this.evalMatchUntilNode.getChildNodeUntil();
            this.stateUntil = childUntil.newState(this, null, 0L);
        }
        if (this.stateUntil != null) {
            this.stateUntil.start(beginState);
        }
        this.initBounds();
        if (this.stateMatcher != null) {
            this.stateMatcher.start(beginState);
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        MatchedEventMap consolidated;
        boolean isMatcher = false;
        if (fromNode == this.stateMatcher) {
            isMatcher = true;
            ++this.numMatches;
            int[] tags = this.evalMatchUntilNode.getFactoryNode().getTagsArrayed();
            for (int i = 0; i < tags.length; ++i) {
                Object theEvent = matchEvent.getMatchingEventAsObject(tags[i]);
                if (theEvent == null) continue;
                if (this.matchedEventArrays[i] == null) {
                    this.matchedEventArrays[i] = new ArrayList();
                }
                if (theEvent instanceof EventBean) {
                    this.matchedEventArrays[i].add((EventBean)theEvent);
                    continue;
                }
                EventBean[] arrayEvents = (EventBean[])theEvent;
                this.matchedEventArrays[i].addAll(Arrays.asList(arrayEvents));
            }
        }
        if (isQuitted) {
            if (isMatcher) {
                this.stateMatcher = null;
            } else {
                this.stateUntil = null;
            }
        }
        if (isMatcher) {
            if (this.isTightlyBound() && this.numMatches == this.lowerbounds) {
                this.quit();
                consolidated = EvalMatchUntilStateNode.consolidate(matchEvent, this.matchedEventArrays, this.evalMatchUntilNode.getFactoryNode().getTagsArrayed());
                this.getParentEvaluator().evaluateTrue(consolidated, this, true);
            } else {
                boolean restart;
                boolean bl = restart = !this.isBounded() || this.upperbounds == null || this.upperbounds > this.numMatches;
                if (this.stateMatcher == null) {
                    if (restart) {
                        EvalNode childMatcher = this.evalMatchUntilNode.getChildNodeSub();
                        this.stateMatcher = childMatcher.newState(this, null, 0L);
                        this.stateMatcher.start(this.beginState);
                    }
                } else if (!restart) {
                    this.stateMatcher.quit();
                    this.stateMatcher = null;
                }
            }
        } else {
            this.quit();
            consolidated = EvalMatchUntilStateNode.consolidate(matchEvent, this.matchedEventArrays, this.evalMatchUntilNode.getFactoryNode().getTagsArrayed());
            if (this.lowerbounds != null && this.numMatches < this.lowerbounds) {
                this.getParentEvaluator().evaluateFalse(this);
            } else {
                this.getParentEvaluator().evaluateTrue(consolidated, this, true);
            }
        }
    }

    private static MatchedEventMap consolidate(MatchedEventMap beginState, ArrayList<EventBean>[] matchedEventList, int[] tagsArrayed) {
        if (tagsArrayed == null) {
            return beginState;
        }
        for (int i = 0; i < tagsArrayed.length; ++i) {
            if (matchedEventList[i] == null) continue;
            EventBean[] eventsForTag = matchedEventList[i].toArray(new EventBean[matchedEventList[i].size()]);
            beginState.add(tagsArrayed[i], eventsForTag);
        }
        return beginState;
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        boolean isMatcher = false;
        if (fromNode == this.stateMatcher) {
            isMatcher = true;
        }
        if (isMatcher) {
            this.stateMatcher.quit();
            this.stateMatcher = null;
        } else {
            this.stateUntil.quit();
            this.stateUntil = null;
            this.getParentEvaluator().evaluateFalse(this);
        }
    }

    @Override
    public final void quit() {
        if (this.stateMatcher != null) {
            this.stateMatcher.quit();
            this.stateMatcher = null;
        }
        if (this.stateUntil != null) {
            this.stateUntil.quit();
            this.stateUntil = null;
        }
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        if (this.stateMatcher != null) {
            this.stateMatcher.accept(visitor, data);
        }
        if (this.stateUntil != null) {
            this.stateUntil.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvalMatchUntilStateNode";
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    private boolean isTightlyBound() {
        return this.lowerbounds != null && this.upperbounds != null && this.upperbounds.equals(this.lowerbounds);
    }

    private boolean isBounded() {
        return this.lowerbounds != null || this.upperbounds != null;
    }

    protected void initBounds() {
        EventBean[] eventsPerStream = this.evalMatchUntilNode.getFactoryNode().getConvertor().convert(this.beginState);
        if (this.evalMatchUntilNode.getFactoryNode().getLowerBounds() != null) {
            this.lowerbounds = (Integer)this.evalMatchUntilNode.getFactoryNode().getLowerBounds().getExprEvaluator().evaluate(eventsPerStream, true, this.evalMatchUntilNode.getContext().getAgentInstanceContext());
        }
        if (this.evalMatchUntilNode.getFactoryNode().getUpperBounds() != null) {
            this.upperbounds = (Integer)this.evalMatchUntilNode.getFactoryNode().getUpperBounds().getExprEvaluator().evaluate(eventsPerStream, true, this.evalMatchUntilNode.getContext().getAgentInstanceContext());
        }
        if (this.upperbounds != null && this.lowerbounds != null && this.upperbounds < this.lowerbounds) {
            Integer lbounds = this.lowerbounds;
            this.lowerbounds = this.upperbounds;
            this.upperbounds = lbounds;
        }
    }
}

