/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalOrNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvalOrStateNode
extends EvalStateNode
implements Evaluator {
    protected final EvalOrNode evalOrNode;
    protected final EvalStateNode[] childNodes;
    private static final Log log = LogFactory.getLog(EvalOrStateNode.class);

    public EvalOrStateNode(Evaluator parentNode, EvalOrNode evalOrNode) {
        super(parentNode);
        this.childNodes = new EvalStateNode[evalOrNode.getChildNodes().length];
        this.evalOrNode = evalOrNode;
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalOrNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        int count = 0;
        for (EvalNode node : this.evalOrNode.getChildNodes()) {
            EvalStateNode childState = node.newState(this, null, 0L);
            this.childNodes[count++] = childState;
        }
        EvalStateNode[] childNodeCopy = new EvalStateNode[this.childNodes.length];
        System.arraycopy(this.childNodes, 0, childNodeCopy, 0, this.childNodes.length);
        for (EvalStateNode child : childNodeCopy) {
            child.start(beginState);
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (isQuitted) {
            for (int i = 0; i < this.childNodes.length; ++i) {
                if (this.childNodes[i] != fromNode) continue;
                this.childNodes[i] = null;
            }
            this.quit();
        }
        this.getParentEvaluator().evaluateTrue(matchEvent, this, isQuitted);
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        for (int i = 0; i < this.childNodes.length; ++i) {
            if (this.childNodes[i] != fromNode) continue;
            this.childNodes[i] = null;
        }
        boolean allEmpty = true;
        for (int i = 0; i < this.childNodes.length; ++i) {
            if (this.childNodes[i] == null) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            this.getParentEvaluator().evaluateFalse(this);
        }
    }

    @Override
    public final void quit() {
        for (EvalStateNode child : this.childNodes) {
            if (child == null) continue;
            child.quit();
        }
        Arrays.fill(this.childNodes, null);
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode node : this.childNodes) {
            if (node == null) continue;
            node.accept(visitor, data);
        }
        return data;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    public final String toString() {
        return "EvalOrStateNode";
    }
}

