/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalRootState;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternMatchCallback;
import com.espertech.esper.pattern.PatternStopCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvalRootStateNode
extends EvalStateNode
implements Evaluator,
PatternStopCallback,
EvalRootState {
    protected EvalNode rootSingleChildNode;
    protected EvalStateNode topStateNode;
    private PatternMatchCallback callback;
    private static final Log log = LogFactory.getLog(EvalRootStateNode.class);

    public EvalRootStateNode(EvalNode rootSingleChildNode) {
        super(null);
        this.rootSingleChildNode = rootSingleChildNode;
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.rootSingleChildNode;
    }

    @Override
    public final void setCallback(PatternMatchCallback callback) {
        this.callback = callback;
    }

    @Override
    public void startRecoverable(boolean startRecoverable, MatchedEventMap beginState) {
        this.start(beginState);
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        this.topStateNode = this.rootSingleChildNode.newState(this, null, 0L);
        this.topStateNode.start(beginState);
    }

    @Override
    public final void stop() {
        this.quit();
    }

    @Override
    public void quit() {
        if (this.topStateNode != null) {
            this.topStateNode.quit();
            this.handleQuitEvent();
        }
        this.topStateNode = null;
    }

    public void handleQuitEvent() {
    }

    public void handleChildQuitEvent() {
    }

    public void handleEvaluateFalseEvent() {
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (isQuitted) {
            this.topStateNode = null;
            this.handleChildQuitEvent();
        }
        this.callback.matchFound(matchEvent.getMatchingEventsAsMap());
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        if (this.topStateNode != null) {
            this.topStateNode.quit();
            this.topStateNode = null;
            this.handleEvaluateFalseEvent();
        }
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        if (this.topStateNode != null) {
            this.topStateNode.accept(visitor, data);
        }
        return data;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    public final String toString() {
        return "EvalRootStateNode topStateNode=" + this.topStateNode;
    }

    public EvalStateNode getTopStateNode() {
        return this.topStateNode;
    }
}

