/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class MatchedEventMapMeta {
    private static final int MIN_MAP_LOOKUP = 3;
    private final String[] tagsPerIndex;
    private final boolean hasArrayProperties;
    private final Map<String, Integer> tagsPerIndexMap;

    public MatchedEventMapMeta(String[] tagsPerIndex, boolean hasArrayProperties) {
        this.tagsPerIndex = tagsPerIndex;
        this.hasArrayProperties = hasArrayProperties;
        this.tagsPerIndexMap = this.getMap(tagsPerIndex);
    }

    public MatchedEventMapMeta(Set<String> allTags, boolean hasArrayProperties) {
        this.tagsPerIndex = allTags.toArray(new String[allTags.size()]);
        this.hasArrayProperties = hasArrayProperties;
        this.tagsPerIndexMap = this.getMap(this.tagsPerIndex);
    }

    public String[] getTagsPerIndex() {
        return this.tagsPerIndex;
    }

    public int getTagFor(String key) {
        if (this.tagsPerIndexMap != null) {
            Integer result = this.tagsPerIndexMap.get(key);
            return result == null ? -1 : result;
        }
        for (int i = 0; i < this.tagsPerIndex.length; ++i) {
            if (!this.tagsPerIndex[i].equals(key)) continue;
            return i;
        }
        return -1;
    }

    private Map<String, Integer> getMap(String[] tagsPerIndex) {
        if (tagsPerIndex.length < 3) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < tagsPerIndex.length; ++i) {
            map.put(tagsPerIndex[i], i);
        }
        return map;
    }

    public boolean isHasArrayProperties() {
        return this.hasArrayProperties;
    }
}

