/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.pattern.EvalEveryDistinctNode;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PatternExpressionUtil {
    private static Log log = LogFactory.getLog(PatternExpressionUtil.class);

    public static Object getKeys(MatchedEventMap currentState, EvalEveryDistinctNode everyDistinctNode) {
        EventBean[] eventsPerStream = everyDistinctNode.getFactoryNode().getConvertor().convert(currentState);
        ExprEvaluator[] expressions = everyDistinctNode.getFactoryNode().getDistinctExpressionsArray();
        if (expressions.length == 1) {
            return expressions[0].evaluate(eventsPerStream, true, everyDistinctNode.getContext().getAgentInstanceContext());
        }
        Object[] keys = new Object[expressions.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = expressions[i].evaluate(eventsPerStream, true, everyDistinctNode.getContext().getAgentInstanceContext());
        }
        return new MultiKeyUntyped(keys);
    }

    public static List<Object> evaluate(String objectName, MatchedEventMap beginState, List<ExprNode> parameters, MatchedEventConvertor convertor, ExprEvaluatorContext exprEvaluatorContext) throws EPException {
        ArrayList<Object> results = new ArrayList<Object>();
        int count = 0;
        EventBean[] eventsPerStream = convertor.convert(beginState);
        for (ExprNode expr : parameters) {
            try {
                Object result = PatternExpressionUtil.evaluate(objectName, expr, eventsPerStream, exprEvaluatorContext);
                results.add(result);
                ++count;
            }
            catch (RuntimeException ex) {
                String message = objectName + " invalid parameter in expression " + count;
                if (ex.getMessage() != null) {
                    message = message + ": " + ex.getMessage();
                }
                log.error((Object)message, (Throwable)ex);
                throw new EPException(message);
            }
        }
        return results;
    }

    public static Object evaluate(String objectName, MatchedEventMap beginState, ExprNode parameter, MatchedEventConvertor convertor, ExprEvaluatorContext exprEvaluatorContext) throws EPException {
        EventBean[] eventsPerStream = convertor.convert(beginState);
        return PatternExpressionUtil.evaluate(objectName, parameter, eventsPerStream, exprEvaluatorContext);
    }

    private static Object evaluate(String objectName, ExprNode expression, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) throws EPException {
        try {
            return expression.getExprEvaluator().evaluate(eventsPerStream, true, exprEvaluatorContext);
        }
        catch (RuntimeException ex) {
            String message = objectName + " failed to evaluate expression";
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            log.error((Object)message, (Throwable)ex);
            throw new EPException(message);
        }
    }
}

