/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.guard;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.guard.Guard;
import com.espertech.esper.pattern.guard.Quitable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpressionGuard
implements Guard {
    private static Log log = LogFactory.getLog(ExpressionGuard.class);
    private final Quitable quitable;
    private final MatchedEventConvertor convertor;
    private final ExprEvaluator expression;

    public ExpressionGuard(MatchedEventConvertor convertor, ExprEvaluator expression, Quitable quitable) {
        this.quitable = quitable;
        this.convertor = convertor;
        this.expression = expression;
    }

    @Override
    public void startGuard() {
    }

    @Override
    public boolean inspect(MatchedEventMap matchEvent) {
        EventBean[] eventsPerStream = this.convertor.convert(matchEvent);
        try {
            Object result = this.expression.evaluate(eventsPerStream, true, this.quitable.getContext().getAgentInstanceContext());
            if (result == null) {
                return false;
            }
            if (result.equals(Boolean.TRUE)) {
                return true;
            }
            this.quitable.guardQuit();
            return false;
        }
        catch (RuntimeException ex) {
            String message = "Failed to evaluate expression for pattern-guard for statement '" + this.quitable.getContext().getPatternContext().getStatementName() + "'";
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            log.error((Object)message, (Throwable)ex);
            throw new EPException(message);
        }
    }

    @Override
    public void stopGuard() {
    }
}

