/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.guard;

import com.espertech.esper.client.EPException;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.pattern.EvalStateNodeNumber;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternExpressionUtil;
import com.espertech.esper.pattern.guard.Guard;
import com.espertech.esper.pattern.guard.GuardFactory;
import com.espertech.esper.pattern.guard.GuardParameterException;
import com.espertech.esper.pattern.guard.Quitable;
import com.espertech.esper.pattern.guard.TimerWithinGuard;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.List;

public class TimerWithinGuardFactory
implements GuardFactory,
MetaDefItem,
Serializable {
    private static final long serialVersionUID = -1026320055174163611L;
    protected ExprNode millisecondsExpr;
    protected transient MatchedEventConvertor convertor;

    @Override
    public void setGuardParameters(List<ExprNode> parameters, MatchedEventConvertor convertor) throws GuardParameterException {
        String errorMessage = "Timer-within guard requires a single numeric or time period parameter";
        if (parameters.size() != 1) {
            throw new GuardParameterException(errorMessage);
        }
        if (!JavaClassHelper.isNumeric(parameters.get(0).getExprEvaluator().getType())) {
            throw new GuardParameterException(errorMessage);
        }
        this.convertor = convertor;
        this.millisecondsExpr = parameters.get(0);
    }

    protected long computeMilliseconds(MatchedEventMap beginState, PatternAgentInstanceContext context) {
        Object millisecondVal = PatternExpressionUtil.evaluate("Timer-within guard", beginState, this.millisecondsExpr, this.convertor, (ExprEvaluatorContext)context.getAgentInstanceContext());
        if (millisecondVal == null) {
            throw new EPException("Timer-within guard expression returned a null-value");
        }
        Number param = (Number)millisecondVal;
        return Math.round(1000.0 * param.doubleValue());
    }

    @Override
    public Guard makeGuard(PatternAgentInstanceContext context, MatchedEventMap matchedEventMap, Quitable quitable, EvalStateNodeNumber stateNodeId, Object guardState) {
        return new TimerWithinGuard(this.computeMilliseconds(matchedEventMap, context), quitable);
    }
}

