/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.observer;

import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.observer.EventObserver;
import com.espertech.esper.pattern.observer.ObserverEventEvaluator;
import com.espertech.esper.schedule.ScheduleComputeHelper;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.schedule.ScheduleSpec;
import com.espertech.esper.schedule.SchedulingService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimerAtObserver
implements EventObserver,
ScheduleHandleCallback {
    private final ScheduleSpec scheduleSpec;
    private final ScheduleSlot scheduleSlot;
    private final MatchedEventMap beginState;
    private final ObserverEventEvaluator observerEventEvaluator;
    private boolean isTimerActive = false;
    private EPStatementHandleCallback scheduleHandle;
    private static final Log log = LogFactory.getLog(TimerAtObserver.class);

    public TimerAtObserver(ScheduleSpec scheduleSpec, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator) {
        this.scheduleSpec = scheduleSpec;
        this.beginState = beginState;
        this.observerEventEvaluator = observerEventEvaluator;
        this.scheduleSlot = observerEventEvaluator.getContext().getPatternContext().getScheduleBucket().allocateSlot();
    }

    @Override
    public final void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
        this.observerEventEvaluator.observerEvaluateTrue(this.beginState);
        this.isTimerActive = false;
    }

    @Override
    public void startObserve() {
        if (this.isTimerActive) {
            throw new IllegalStateException("Timer already active");
        }
        this.scheduleHandle = new EPStatementHandleCallback(this.observerEventEvaluator.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle(), this);
        SchedulingService schedulingService = this.observerEventEvaluator.getContext().getPatternContext().getSchedulingService();
        long nextScheduledTime = ScheduleComputeHelper.computeDeltaNextOccurance(this.scheduleSpec, schedulingService.getTime());
        schedulingService.add(nextScheduledTime, this.scheduleHandle, this.scheduleSlot);
        this.isTimerActive = true;
    }

    @Override
    public void stopObserve() {
        if (this.isTimerActive) {
            this.observerEventEvaluator.getContext().getPatternContext().getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            this.isTimerActive = false;
            this.scheduleHandle = null;
        }
    }
}

