/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.observer;

import com.espertech.esper.client.EPException;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.pattern.EvalStateNodeNumber;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.observer.EventObserver;
import com.espertech.esper.pattern.observer.ObserverEventEvaluator;
import com.espertech.esper.pattern.observer.ObserverFactory;
import com.espertech.esper.pattern.observer.ObserverParameterException;
import com.espertech.esper.pattern.observer.TimerIntervalObserver;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.List;

public class TimerIntervalObserverFactory
implements ObserverFactory,
MetaDefItem,
Serializable {
    private static final long serialVersionUID = -2808651894497586884L;
    protected ExprNode parameter;
    protected transient MatchedEventConvertor convertor;

    @Override
    public void setObserverParameters(List<ExprNode> parameters, MatchedEventConvertor convertor) throws ObserverParameterException {
        String errorMessage = "Timer-interval observer requires a single numeric or time period parameter";
        if (parameters.size() != 1) {
            throw new ObserverParameterException(errorMessage);
        }
        Class returnType = parameters.get(0).getExprEvaluator().getType();
        if (!JavaClassHelper.isNumeric(returnType)) {
            throw new ObserverParameterException(errorMessage);
        }
        this.parameter = parameters.get(0);
        this.convertor = convertor;
    }

    protected long computeMilliseconds(MatchedEventMap beginState, PatternAgentInstanceContext context) {
        Object result = this.parameter.getExprEvaluator().evaluate(this.convertor.convert(beginState), true, context.getAgentInstanceContext());
        if (result == null) {
            throw new EPException("Null value returned for guard expression");
        }
        Number param = (Number)result;
        if (JavaClassHelper.isFloatingPointNumber(param)) {
            return Math.round(1000.0 * param.doubleValue());
        }
        return 1000L * param.longValue();
    }

    @Override
    public EventObserver makeObserver(PatternAgentInstanceContext context, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator, EvalStateNodeNumber stateNodeId, Object observerState) {
        return new TimerIntervalObserver(this.computeMilliseconds(beginState, context), beginState, observerEventEvaluator);
    }
}

