/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.rowregex;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.rowregex.MultimatchState;
import com.espertech.esper.rowregex.RegexNFAStateEntry;
import com.espertech.esper.rowregex.RegexPartitionStateRandomAccessGetter;
import com.espertech.esper.rowregex.RegexPartitionStateRandomAccessImpl;
import java.util.ArrayList;
import java.util.List;

public class RegexPartitionState {
    private RegexPartitionStateRandomAccessImpl randomAccess;
    private List<RegexNFAStateEntry> currentStates = new ArrayList<RegexNFAStateEntry>();
    private Object optionalKeys;
    private List<RegexNFAStateEntry> intervalCallbackItems;
    private boolean isCallbackScheduled;

    public RegexPartitionState(RegexPartitionStateRandomAccessImpl randomAccess, Object optionalKeys, boolean hasInterval) {
        this.randomAccess = randomAccess;
        this.optionalKeys = optionalKeys;
        if (hasInterval) {
            this.intervalCallbackItems = new ArrayList<RegexNFAStateEntry>();
        }
    }

    public RegexPartitionState(RegexPartitionStateRandomAccessGetter getter, List<RegexNFAStateEntry> currentStates, boolean hasInterval) {
        this(getter, currentStates, null, hasInterval);
    }

    public RegexPartitionState(RegexPartitionStateRandomAccessGetter getter, List<RegexNFAStateEntry> currentStates, Object optionalKeys, boolean hasInterval) {
        if (getter != null) {
            this.randomAccess = new RegexPartitionStateRandomAccessImpl(getter);
        }
        this.currentStates = currentStates;
        this.optionalKeys = optionalKeys;
        if (hasInterval) {
            this.intervalCallbackItems = new ArrayList<RegexNFAStateEntry>();
        }
    }

    public RegexPartitionStateRandomAccessImpl getRandomAccess() {
        return this.randomAccess;
    }

    public List<RegexNFAStateEntry> getCurrentStates() {
        return this.currentStates;
    }

    public void setCurrentStates(List<RegexNFAStateEntry> currentStates) {
        this.currentStates = currentStates;
    }

    public Object getOptionalKeys() {
        return this.optionalKeys;
    }

    public void removeEventFromPrev(EventBean[] oldEvents) {
        if (this.randomAccess != null) {
            this.randomAccess.remove(oldEvents);
        }
    }

    public void removeEventFromPrev(EventBean oldEvent) {
        if (this.randomAccess != null) {
            this.randomAccess.remove(oldEvent);
        }
    }

    public boolean removeEventFromState(EventBean oldEvent) {
        ArrayList<RegexNFAStateEntry> keepList = new ArrayList<RegexNFAStateEntry>();
        for (RegexNFAStateEntry entry : this.currentStates) {
            MultimatchState[] multimatch;
            EventBean[] state;
            boolean keep = true;
            for (EventBean aState : state = entry.getEventsPerStream()) {
                if (aState != oldEvent) continue;
                keep = false;
                break;
            }
            if (keep && (multimatch = entry.getOptionalMultiMatches()) != null) {
                for (MultimatchState aMultimatch : multimatch) {
                    if (aMultimatch == null || !aMultimatch.containsEvent(oldEvent)) continue;
                    keep = false;
                    break;
                }
            }
            if (!keep) continue;
            keepList.add(entry);
        }
        if (this.randomAccess != null) {
            this.randomAccess.remove(oldEvent);
        }
        this.currentStates = keepList;
        return keepList.isEmpty();
    }

    public List<RegexNFAStateEntry> getCallbackItems() {
        return this.intervalCallbackItems;
    }

    public boolean isCallbackScheduled() {
        return this.isCallbackScheduled;
    }

    public void setCallbackScheduled(boolean callbackScheduled) {
        this.isCallbackScheduled = callbackScheduled;
    }

    public void addCallbackItem(RegexNFAStateEntry endState) {
        this.intervalCallbackItems.add(endState);
    }
}

