/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.timer;

import com.espertech.esper.timer.TimeSourceService;

public class TimeSourceServiceImpl
implements TimeSourceService {
    private static final long MICROS_TO_MILLIS = 1000L;
    private static final long NANOS_TO_MICROS = 1000L;
    public static boolean IS_SYSTEM_CURRENT_TIME = true;
    private final long wallClockOffset = System.currentTimeMillis() * 1000L - this.getTimeMicros();
    private final String description = String.format("%s: resolution %d microsecs", this.getClass().getSimpleName(), this.calculateResolution());

    @Override
    public long getTimeMillis() {
        if (IS_SYSTEM_CURRENT_TIME) {
            return System.currentTimeMillis();
        }
        return this.getTimeMicros() / 1000L;
    }

    private long getTimeMicros() {
        return System.nanoTime() / 1000L + this.wallClockOffset;
    }

    protected long calculateResolution() {
        long time;
        int LOOPS = 5;
        long totalResolution = 0L;
        long prevTime = time = this.getTimeMicros();
        for (int i = 0; i < 5; ++i) {
            while (time == prevTime) {
                time = this.getTimeMicros();
            }
            totalResolution += time - prevTime;
            prevTime = time;
        }
        return totalResolution / 5L;
    }

    public String toString() {
        return this.description;
    }
}

