/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.event.EventBeanUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuditPath {
    private static final Log auditLogDestination = LogFactory.getLog((String)"com.espertech.esper.audit");
    public static final String QUERYPLAN_LOG = "com.espertech.esper.queryplan";
    public static final String JDBC_LOG = "com.espertech.esper.jdbc";
    public static final String AUDIT_LOG = "com.espertech.esper.audit";
    public static boolean isAuditEnabled = false;
    private static String auditPattern;

    public static void setAuditPattern(String auditPattern) {
        AuditPath.auditPattern = auditPattern;
    }

    public static void auditInsertInto(String engineURI, String statementName, EventBean theEvent) {
        AuditPath.auditLog(engineURI, statementName, AuditEnum.INSERT, EventBeanUtility.summarize(theEvent));
    }

    public static void auditLog(String engineURI, String statementName, AuditEnum category, String message) {
        if (auditPattern == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("Statement ");
            buf.append(statementName);
            buf.append(" ");
            buf.append(category.getPrettyPrintText());
            buf.append(" ");
            buf.append(message);
            auditLogDestination.info((Object)buf.toString());
        } else {
            String result = auditPattern.replace("%s", statementName).replace("%u", engineURI).replace("%c", category.getValue()).replace("%m", message);
            auditLogDestination.info((Object)result);
        }
    }

    public static boolean isInfoEnabled() {
        return auditLogDestination.isInfoEnabled();
    }
}

