/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Scanner;

public class FileUtil {
    public static String findClasspathFile(String filename) {
        URL url = FileUtil.class.getClassLoader().getResource(filename);
        if (url != null) {
            return url.getFile();
        }
        return null;
    }

    public static void findDeleteClasspathFile(String filename) {
        URL url = FileUtil.class.getClassLoader().getResource(filename);
        if (url != null) {
            File file = new File(url.getFile());
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readClasspathTextFile(String filename) {
        String filenameCp = FileUtil.findClasspathFile(filename);
        if (filenameCp == null) {
            throw new RuntimeException("Failed to find file '" + filename + "' in classpath");
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            FileInputStream fis = new FileInputStream(filenameCp);
            Scanner scanner = new Scanner(fis);
            try {
                while (scanner.hasNextLine()) {
                    lines.add(scanner.nextLine());
                }
            }
            finally {
                scanner.close();
                fis.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read file '" + filename + "': " + ex.getMessage(), ex);
        }
        return lines.toArray(new String[lines.size()]);
    }
}

