/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeSummaryVisitor;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewParameterException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ViewFactorySupport
implements ViewFactory {
    private static Log log = LogFactory.getLog(ViewFactorySupport.class);

    @Override
    public boolean canReuse(View view) {
        return false;
    }

    public static Object validateAndEvaluate(String viewName, StatementContext statementContext, ExprNode expression) throws ViewParameterException {
        return ViewFactorySupport.validateAndEvaluateExpr(statementContext, expression, new StreamTypeServiceImpl(statementContext.getEngineURI(), false), 0);
    }

    public static List<Object> validateAndEvaluate(String viewName, StatementContext statementContext, List<ExprNode> expressions) throws ViewParameterException {
        ArrayList<Object> results = new ArrayList<Object>();
        int expressionNumber = 0;
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(statementContext.getEngineURI(), false);
        for (ExprNode expr : expressions) {
            Object result = ViewFactorySupport.validateAndEvaluateExpr(statementContext, expr, streamTypeService, expressionNumber);
            results.add(result);
            ++expressionNumber;
        }
        return results;
    }

    public static ExprNode[] validate(String viewName, EventType eventType, StatementContext statementContext, List<ExprNode> expressions, boolean allowConstantResult) throws ViewParameterException {
        ArrayList<ExprNode> results = new ArrayList<ExprNode>();
        int expressionNumber = 0;
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(eventType, null, false, statementContext.getEngineURI());
        for (ExprNode expr : expressions) {
            ExprNode validated = ViewFactorySupport.validateExpr(statementContext, expr, streamTypeService, expressionNumber);
            results.add(validated);
            if (!allowConstantResult && validated.isConstantResult()) {
                String message = "Invalid view parameter expression " + expressionNumber + ", the expression returns a constant result value, are you sure?";
                log.error((Object)message);
                throw new ViewParameterException(message);
            }
            ++expressionNumber;
        }
        return results.toArray(new ExprNode[results.size()]);
    }

    public static void assertReturnsNonConstant(String viewName, ExprNode expression, int index) throws ViewParameterException {
        if (expression.isConstantResult()) {
            String message = "Invalid view parameter expression " + index + ", the expression returns a constant result value, are you sure?";
            log.error((Object)message);
            throw new ViewParameterException(message);
        }
    }

    public static Object evaluateAssertNoProperties(String viewName, ExprNode expression, int index, ExprEvaluatorContext exprEvaluatorContext) throws ViewParameterException {
        ExprNodeSummaryVisitor visitor = new ExprNodeSummaryVisitor();
        expression.accept(visitor);
        if (!visitor.isPlain()) {
            String message = "Invalid view parameter expression " + index + ", " + visitor.getMessage() + " are not allowed within the expression";
            throw new ViewParameterException(message);
        }
        return expression.getExprEvaluator().evaluate(null, false, exprEvaluatorContext);
    }

    private static Object validateAndEvaluateExpr(StatementContext statementContext, ExprNode expression, StreamTypeService streamTypeService, int expressionNumber) throws ViewParameterException {
        ExprNode validated = ViewFactorySupport.validateExpr(statementContext, expression, streamTypeService, expressionNumber);
        try {
            return validated.getExprEvaluator().evaluate(null, true, new ExprEvaluatorContextStatement(statementContext));
        }
        catch (RuntimeException ex) {
            String message = "Failed to evaluate parameter expression " + expressionNumber;
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            log.error((Object)message, (Throwable)ex);
            throw new ViewParameterException(message, ex);
        }
    }

    public static ExprNode validateExpr(StatementContext statementContext, ExprNode expression, StreamTypeService streamTypeService, int expressionNumber) throws ViewParameterException {
        ExprNode validated;
        try {
            ExprEvaluatorContextStatement exprEvaluatorContext = new ExprEvaluatorContextStatement(statementContext);
            ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, statementContext.getMethodResolutionService(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), exprEvaluatorContext, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor());
            validated = ExprNodeUtility.getValidatedSubtree(expression, validationContext);
        }
        catch (ExprValidationException ex) {
            String message = "Invalid parameter expression " + expressionNumber;
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            log.error((Object)message, (Throwable)ex);
            throw new ViewParameterException(message, ex);
        }
        return validated;
    }
}

