/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.ext.IStreamSortRankRandomAccess;
import com.espertech.esper.view.ext.RankWindowIterator;
import com.espertech.esper.view.ext.RankWindowViewFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RankWindowView
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final RankWindowViewFactory rankWindowViewFactory;
    protected final ExprEvaluator[] sortCriteriaEvaluators;
    private final ExprNode[] sortCriteriaExpressions;
    protected final ExprEvaluator[] uniqueCriteriaEvaluators;
    private final ExprNode[] uniqueCriteriaExpressions;
    private final EventBean[] eventsPerStream = new EventBean[1];
    private final boolean[] isDescendingValues;
    private final int sortWindowSize;
    private final IStreamSortRankRandomAccess optionalRankedRandomAccess;
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private final Comparator<Object> comparator;
    protected TreeMap<Object, Object> sortedEvents;
    protected Map<Object, Object> uniqueKeySortKeys;
    protected int numberOfEvents;
    private static final Log log = LogFactory.getLog(RankWindowView.class);

    public RankWindowView(RankWindowViewFactory rankWindowViewFactory, ExprNode[] uniqueCriteriaExpressions, ExprEvaluator[] uniqueCriteriaEvaluators, ExprNode[] sortCriteriaExpressions, ExprEvaluator[] sortCriteriaEvaluators, boolean[] descendingValues, int sortWindowSize, IStreamSortRankRandomAccess optionalRankedRandomAccess, boolean isSortUsingCollator, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        this.rankWindowViewFactory = rankWindowViewFactory;
        this.uniqueCriteriaExpressions = uniqueCriteriaExpressions;
        this.uniqueCriteriaEvaluators = uniqueCriteriaEvaluators;
        this.sortCriteriaExpressions = sortCriteriaExpressions;
        this.sortCriteriaEvaluators = sortCriteriaEvaluators;
        this.isDescendingValues = descendingValues;
        this.sortWindowSize = sortWindowSize;
        this.optionalRankedRandomAccess = optionalRankedRandomAccess;
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.comparator = CollectionUtil.getComparator(sortCriteriaEvaluators, isSortUsingCollator, this.isDescendingValues);
        this.sortedEvents = new TreeMap(this.comparator);
        this.uniqueKeySortKeys = new HashMap<Object, Object>();
    }

    @Override
    public View cloneView() {
        return this.rankWindowViewFactory.makeView(this.agentInstanceViewFactoryContext);
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        Object uniqueKey;
        int i;
        OneEventCollection removedEvents = new OneEventCollection();
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                EventBean event;
                uniqueKey = this.getUniqueValues(oldData[i]);
                Object existingSortKey = this.uniqueKeySortKeys.get(uniqueKey);
                if (existingSortKey == null || (event = this.removeFromSortedEvents(existingSortKey, uniqueKey)) == null) continue;
                --this.numberOfEvents;
                this.uniqueKeySortKeys.remove(uniqueKey);
                removedEvents.add(event);
                this.internalHandleRemovedKey(existingSortKey, oldData[i]);
            }
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                uniqueKey = this.getUniqueValues(newData[i]);
                Object newSortKey = this.getSortValues(newData[i]);
                Object existingSortKey = this.uniqueKeySortKeys.get(uniqueKey);
                if (existingSortKey == null) {
                    this.compareAndAddOrPassthru(newData[i], uniqueKey, newSortKey, removedEvents);
                    continue;
                }
                if (existingSortKey.equals(newSortKey)) {
                    EventBean replaced = this.inplaceReplaceSortedEvents(existingSortKey, uniqueKey, newData[i]);
                    if (replaced != null) {
                        removedEvents.add(replaced);
                    }
                    this.internalHandleReplacedKey(newSortKey, newData[i], replaced);
                    continue;
                }
                EventBean removed = this.removeFromSortedEvents(existingSortKey, uniqueKey);
                if (removed != null) {
                    --this.numberOfEvents;
                    removedEvents.add(removed);
                    this.internalHandleRemovedKey(existingSortKey, removed);
                }
                this.compareAndAddOrPassthru(newData[i], uniqueKey, newSortKey, removedEvents);
            }
        }
        if (this.numberOfEvents > this.sortWindowSize) {
            while (this.numberOfEvents > this.sortWindowSize) {
                Object lastKey = this.sortedEvents.lastKey();
                Object existing = this.sortedEvents.get(lastKey);
                if (existing instanceof List) {
                    List existingList = (List)existing;
                    while (this.numberOfEvents > this.sortWindowSize && !existingList.isEmpty()) {
                        EventBean newestEvent = (EventBean)existingList.remove(0);
                        Object uniqueKey2 = this.getUniqueValues(newestEvent);
                        this.uniqueKeySortKeys.remove(uniqueKey2);
                        --this.numberOfEvents;
                        removedEvents.add(newestEvent);
                        this.internalHandleRemovedKey(existing, newestEvent);
                    }
                    if (!existingList.isEmpty()) continue;
                    this.sortedEvents.remove(lastKey);
                    continue;
                }
                EventBean lastSortedEvent = (EventBean)existing;
                Object uniqueKey3 = this.getUniqueValues(lastSortedEvent);
                this.uniqueKeySortKeys.remove(uniqueKey3);
                --this.numberOfEvents;
                removedEvents.add(lastSortedEvent);
                this.sortedEvents.remove(lastKey);
                this.internalHandleRemovedKey(lastKey, lastSortedEvent);
            }
        }
        if (this.optionalRankedRandomAccess != null) {
            this.optionalRankedRandomAccess.refresh(this.sortedEvents, this.numberOfEvents, this.sortWindowSize);
        }
        if (this.hasViews()) {
            EventBean[] expiredArr = null;
            if (!removedEvents.isEmpty()) {
                expiredArr = removedEvents.toArray();
            }
            this.updateChildren(newData, expiredArr);
        }
    }

    public void internalHandleReplacedKey(Object newSortKey, EventBean newEvent, EventBean oldEvent) {
    }

    public void internalHandleRemovedKey(Object sortKey, EventBean eventBean) {
    }

    public void internalHandleAddedKey(Object sortKey, EventBean eventBean) {
    }

    private void compareAndAddOrPassthru(EventBean eventBean, Object uniqueKey, Object newSortKey, OneEventCollection removedEvents) {
        if (this.numberOfEvents >= this.sortWindowSize) {
            int compared = this.comparator.compare(this.sortedEvents.lastKey(), newSortKey);
            if (compared < 0) {
                removedEvents.add(eventBean);
            } else {
                this.uniqueKeySortKeys.put(uniqueKey, newSortKey);
                ++this.numberOfEvents;
                CollectionUtil.addEventByKeyLazyListMapBack(newSortKey, eventBean, this.sortedEvents);
                this.internalHandleAddedKey(newSortKey, eventBean);
            }
        } else {
            this.uniqueKeySortKeys.put(uniqueKey, newSortKey);
            ++this.numberOfEvents;
            CollectionUtil.addEventByKeyLazyListMapBack(newSortKey, eventBean, this.sortedEvents);
            this.internalHandleAddedKey(newSortKey, eventBean);
        }
    }

    private EventBean removeFromSortedEvents(Object sortKey, Object uniqueKeyToRemove) {
        Object existing = this.sortedEvents.get(sortKey);
        EventBean removedOldEvent = null;
        if (existing != null) {
            if (existing instanceof List) {
                List existingList = (List)existing;
                Iterator it = existingList.iterator();
                while (it.hasNext()) {
                    EventBean eventForRank = (EventBean)it.next();
                    if (!this.getUniqueValues(eventForRank).equals(uniqueKeyToRemove)) continue;
                    it.remove();
                    removedOldEvent = eventForRank;
                    break;
                }
                if (existingList.isEmpty()) {
                    this.sortedEvents.remove(sortKey);
                }
            } else {
                removedOldEvent = (EventBean)existing;
                this.sortedEvents.remove(sortKey);
            }
        }
        return removedOldEvent;
    }

    private EventBean inplaceReplaceSortedEvents(Object sortKey, Object uniqueKeyToReplace, EventBean newData) {
        Object existing = this.sortedEvents.get(sortKey);
        EventBean replaced = null;
        if (existing != null) {
            if (existing instanceof List) {
                List existingList = (List)existing;
                Iterator it = existingList.iterator();
                while (it.hasNext()) {
                    EventBean eventForRank = (EventBean)it.next();
                    if (!this.getUniqueValues(eventForRank).equals(uniqueKeyToReplace)) continue;
                    it.remove();
                    replaced = eventForRank;
                    break;
                }
                existingList.add(newData);
            } else {
                replaced = (EventBean)existing;
                this.sortedEvents.put(sortKey, newData);
            }
        }
        return replaced;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new RankWindowIterator(this.sortedEvents);
    }

    public final String toString() {
        return this.getClass().getName() + " uniqueFieldName=" + Arrays.toString(this.uniqueCriteriaExpressions) + " sortFieldName=" + Arrays.toString(this.sortCriteriaExpressions) + " isDescending=" + Arrays.toString(this.isDescendingValues) + " sortWindowSize=" + this.sortWindowSize;
    }

    public Object getUniqueValues(EventBean theEvent) {
        return RankWindowView.getCriteriaKey(this.eventsPerStream, this.uniqueCriteriaEvaluators, theEvent, this.agentInstanceViewFactoryContext);
    }

    public Object getSortValues(EventBean theEvent) {
        return RankWindowView.getCriteriaKey(this.eventsPerStream, this.sortCriteriaEvaluators, theEvent, this.agentInstanceViewFactoryContext);
    }

    public static Object getCriteriaKey(EventBean[] eventsPerStream, ExprEvaluator[] evaluators, EventBean theEvent, ExprEvaluatorContext evalContext) {
        eventsPerStream[0] = theEvent;
        if (evaluators.length > 1) {
            return RankWindowView.getCriteriaMultiKey(eventsPerStream, evaluators, evalContext);
        }
        return evaluators[0].evaluate(eventsPerStream, true, evalContext);
    }

    public static MultiKeyUntyped getCriteriaMultiKey(EventBean[] eventsPerStream, ExprEvaluator[] evaluators, ExprEvaluatorContext evalContext) {
        Object[] result = new Object[evaluators.length];
        int count = 0;
        for (ExprEvaluator expr : evaluators) {
            result[count++] = expr.evaluate(eventsPerStream, true, evalContext);
        }
        return new MultiKeyUntyped(result);
    }

    public boolean isEmpty() {
        if (this.sortedEvents == null) {
            return true;
        }
        return this.sortedEvents.isEmpty();
    }
}

