/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprOrderedExpr;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewServiceHelper;
import com.espertech.esper.view.ext.IStreamSortRankRandomAccess;
import com.espertech.esper.view.ext.SortWindowView;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import java.util.List;

public class SortWindowViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    private static final String NAME = "Sort view";
    private List<ExprNode> viewParameters;
    protected ExprNode[] sortCriteriaExpressions;
    protected boolean[] isDescendingValues;
    protected int sortWindowSize;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> viewParams) throws ViewParameterException {
        this.viewParameters = viewParams;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
        String message = "Sort view requires a numeric size parameter and a list of expressions providing sort keys";
        if (this.viewParameters.size() < 2) {
            throw new ViewParameterException(message);
        }
        ExprNode[] validated = ViewFactorySupport.validate(NAME, parentEventType, statementContext, this.viewParameters, true);
        for (int i = 1; i < validated.length; ++i) {
            ViewFactorySupport.assertReturnsNonConstant(NAME, validated[i], i);
        }
        ExprEvaluatorContextStatement exprEvaluatorContext = new ExprEvaluatorContextStatement(statementContext);
        Object sortSize = ViewFactorySupport.evaluateAssertNoProperties(NAME, validated[0], 0, exprEvaluatorContext);
        if (sortSize == null || !(sortSize instanceof Number)) {
            throw new ViewParameterException(message);
        }
        this.sortWindowSize = ((Number)sortSize).intValue();
        this.sortCriteriaExpressions = new ExprNode[validated.length - 1];
        this.isDescendingValues = new boolean[this.sortCriteriaExpressions.length];
        for (int i = 1; i < validated.length; ++i) {
            if (validated[i] instanceof ExprOrderedExpr) {
                this.isDescendingValues[i - 1] = ((ExprOrderedExpr)validated[i]).isDescending();
                this.sortCriteriaExpressions[i - 1] = validated[i].getChildNodes()[0];
                continue;
            }
            this.sortCriteriaExpressions[i - 1] = validated[i];
        }
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        IStreamSortRankRandomAccess sortedRandomAccess = ViewServiceHelper.getOptPreviousExprSortedRankedAccess(agentInstanceViewFactoryContext);
        boolean useCollatorSort = false;
        if (agentInstanceViewFactoryContext.getAgentInstanceContext().getStatementContext().getConfigSnapshot() != null) {
            useCollatorSort = agentInstanceViewFactoryContext.getAgentInstanceContext().getStatementContext().getConfigSnapshot().getEngineDefaults().getLanguage().isSortUsingCollator();
        }
        ExprEvaluator[] childEvals = ExprNodeUtility.getEvaluators(this.sortCriteriaExpressions);
        return new SortWindowView(this, this.sortCriteriaExpressions, childEvals, this.isDescendingValues, this.sortWindowSize, sortedRandomAccess, useCollatorSort, agentInstanceViewFactoryContext);
    }

    @Override
    public Object makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof SortWindowView)) {
            return false;
        }
        SortWindowView other = (SortWindowView)view;
        if (other.getSortWindowSize() != this.sortWindowSize || !this.compare(other.getIsDescendingValues(), this.isDescendingValues) || !ExprNodeUtility.deepEquals(other.getSortCriteriaExpressions(), this.sortCriteriaExpressions)) {
            return false;
        }
        return other.isEmpty();
    }

    private boolean compare(boolean[] one, boolean[] two) {
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (one[i] == two[i]) continue;
            return false;
        }
        return true;
    }
}

