/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.ext.IStreamSortRankRandomAccess;
import com.espertech.esper.view.ext.SortWindowIterator;
import com.espertech.esper.view.ext.TimeOrderViewFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeOrderView
extends ViewSupport
implements DataWindowView,
CloneableView,
StoppableView,
StopCallback {
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final TimeOrderViewFactory timeOrderViewFactory;
    private final ExprNode timestampExpression;
    private final ExprEvaluator timestampEvaluator;
    protected final long intervalSize;
    protected final IStreamSortRankRandomAccess optionalSortedRandomAccess;
    protected final ScheduleSlot scheduleSlot;
    protected final EPStatementHandleCallback handle;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected TreeMap<Object, Object> sortedEvents;
    protected boolean isCallbackScheduled;
    protected int eventCount;
    private static final Log log = LogFactory.getLog(TimeOrderView.class);

    public TimeOrderView(AgentInstanceViewFactoryChainContext agentInstanceContext, TimeOrderViewFactory timeOrderViewFactory, ExprNode timestampExpr, ExprEvaluator timestampEvaluator, long intervalSize, IStreamSortRankRandomAccess optionalSortedRandomAccess) {
        this.agentInstanceContext = agentInstanceContext;
        this.timeOrderViewFactory = timeOrderViewFactory;
        this.timestampExpression = timestampExpr;
        this.timestampEvaluator = timestampEvaluator;
        this.intervalSize = intervalSize;
        this.optionalSortedRandomAccess = optionalSortedRandomAccess;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.sortedEvents = new TreeMap();
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                TimeOrderView.this.expire();
            }
        };
        this.handle = new EPStatementHandleCallback(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        agentInstanceContext.addTerminationCallback(this);
    }

    public ExprNode getTimestampExpression() {
        return this.timestampExpression;
    }

    public long getIntervalSize() {
        return this.intervalSize;
    }

    @Override
    public View cloneView() {
        return this.timeOrderViewFactory.makeView(this.agentInstanceContext);
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        EventBean[] postOldEventsArray = null;
        if (oldData != null) {
            for (int i = 0; i < oldData.length; ++i) {
                EventBean oldDataItem = oldData[i];
                Long sortValues = this.getTimestamp(oldDataItem);
                boolean result = CollectionUtil.removeEventByKeyLazyListMap(sortValues, oldDataItem, this.sortedEvents);
                if (!result) continue;
                --this.eventCount;
                postOldEventsArray = postOldEventsArray == null ? oldData : CollectionUtil.addArrayWithSetSemantics(postOldEventsArray, oldData);
                this.internalHandleRemoved(sortValues, oldDataItem);
            }
        }
        if (newData != null && newData.length > 0) {
            long engineTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            long windowTailTime = engineTime - this.intervalSize + 1L;
            long oldestEvent = Long.MAX_VALUE;
            if (!this.sortedEvents.isEmpty()) {
                oldestEvent = (Long)this.sortedEvents.firstKey();
            }
            boolean addedOlderEvent = false;
            ArrayList<EventBean> postOldEvents = null;
            for (int i = 0; i < newData.length; ++i) {
                EventBean newEvent = newData[i];
                Long timestamp = this.getTimestamp(newEvent);
                if (timestamp < windowTailTime) {
                    if (postOldEvents == null) {
                        postOldEvents = new ArrayList<EventBean>(2);
                    }
                    postOldEvents.add(newEvent);
                    continue;
                }
                if (timestamp < oldestEvent) {
                    addedOlderEvent = true;
                    oldestEvent = timestamp;
                }
                CollectionUtil.addEventByKeyLazyListMapBack(timestamp, newEvent, this.sortedEvents);
                ++this.eventCount;
                this.internalHandleAdd(timestamp, newEvent);
            }
            if (!this.sortedEvents.isEmpty()) {
                if (!this.isCallbackScheduled) {
                    long callbackWait = oldestEvent - windowTailTime + 1L;
                    this.agentInstanceContext.getStatementContext().getSchedulingService().add(callbackWait, this.handle, this.scheduleSlot);
                    this.isCallbackScheduled = true;
                } else if (addedOlderEvent) {
                    oldestEvent = (Long)this.sortedEvents.firstKey();
                    long callbackWait = oldestEvent - windowTailTime + 1L;
                    this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
                    this.agentInstanceContext.getStatementContext().getSchedulingService().add(callbackWait, this.handle, this.scheduleSlot);
                    this.isCallbackScheduled = true;
                }
            }
            if (postOldEvents != null) {
                postOldEventsArray = postOldEvents.toArray(new EventBean[postOldEvents.size()]);
            }
            if (this.optionalSortedRandomAccess != null) {
                this.optionalSortedRandomAccess.refresh(this.sortedEvents, this.eventCount, this.eventCount);
            }
        }
        if (this.hasViews()) {
            this.updateChildren(newData, postOldEventsArray);
        }
    }

    public void internalHandleAdd(Object sortValues, EventBean newDataItem) {
    }

    public void internalHandleRemoved(Object sortValues, EventBean oldDataItem) {
    }

    public void internalHandleExpired(Object sortValues, EventBean oldDataItem) {
    }

    public void internalHandleExpired(Object sortValues, List<EventBean> oldDataItems) {
    }

    protected Long getTimestamp(EventBean newEvent) {
        this.eventsPerStream[0] = newEvent;
        return (Long)this.timestampEvaluator.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
    }

    public boolean isEmpty() {
        return this.sortedEvents.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SortWindowIterator(this.sortedEvents);
    }

    public final String toString() {
        return this.getClass().getName() + " timestampExpression=" + this.timestampExpression + " intervalSize=" + this.intervalSize;
    }

    protected final void expire() {
        Long oldestKey;
        long expireBeforeTimestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime() - this.intervalSize + 1L;
        this.isCallbackScheduled = false;
        ArrayList<EventBean> releaseEvents = null;
        while (true) {
            if (this.sortedEvents.isEmpty()) {
                oldestKey = null;
                break;
            }
            oldestKey = (Long)this.sortedEvents.firstKey();
            if (oldestKey >= expireBeforeTimestamp) break;
            Object released = this.sortedEvents.remove(oldestKey);
            if (released == null) continue;
            if (released instanceof List) {
                List releasedEventList = (List)released;
                if (releaseEvents == null) {
                    releaseEvents = releasedEventList;
                } else {
                    releaseEvents.addAll(releasedEventList);
                }
                this.eventCount -= releasedEventList.size();
                this.internalHandleExpired((Object)oldestKey, releasedEventList);
                continue;
            }
            EventBean releasedEvent = (EventBean)released;
            if (releaseEvents == null) {
                releaseEvents = new ArrayList<EventBean>(4);
            }
            releaseEvents.add(releasedEvent);
            --this.eventCount;
            this.internalHandleExpired((Object)oldestKey, releasedEvent);
        }
        if (this.optionalSortedRandomAccess != null) {
            this.optionalSortedRandomAccess.refresh(this.sortedEvents, this.eventCount, this.eventCount);
        }
        if (this.hasViews() && releaseEvents != null && !releaseEvents.isEmpty()) {
            EventBean[] oldEvents = releaseEvents.toArray(new EventBean[releaseEvents.size()]);
            this.updateChildren(null, oldEvents);
        }
        if (oldestKey == null) {
            return;
        }
        long callbackWait = oldestKey - expireBeforeTimestamp + 1L;
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(callbackWait, this.handle, this.scheduleSlot);
        this.isCallbackScheduled = true;
    }

    @Override
    public void stopView() {
        this.stopSchedule();
        this.agentInstanceContext.removeTerminationCallback(this);
    }

    @Override
    public void stop() {
        this.stopSchedule();
    }

    public void stopSchedule() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }
}

