/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPStatementHandle;
import com.espertech.esper.core.service.InternalEventRouter;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.internal.RouteResultViewHandler;
import com.espertech.esper.view.internal.RouteResultViewHandlerAll;
import com.espertech.esper.view.internal.RouteResultViewHandlerFirst;
import java.util.Iterator;

public class RouteResultView
extends ViewSupport {
    private final EventType eventType;
    private RouteResultViewHandler handler;
    private ExprEvaluatorContext exprEvaluatorContext;

    public RouteResultView(boolean isFirst, EventType eventType, EPStatementHandle epStatementHandle, InternalEventRouter internalEventRouter, boolean[] isNamedWindowInsert, ResultSetProcessor[] processors, ExprNode[] whereClauses, AgentInstanceContext agentInstanceContext) {
        if (whereClauses.length != processors.length) {
            throw new IllegalArgumentException("Number of where-clauses and processors does not match");
        }
        this.exprEvaluatorContext = agentInstanceContext;
        this.eventType = eventType;
        this.handler = isFirst ? new RouteResultViewHandlerFirst(epStatementHandle, internalEventRouter, isNamedWindowInsert, processors, ExprNodeUtility.getEvaluators(whereClauses), agentInstanceContext) : new RouteResultViewHandlerAll(epStatementHandle, internalEventRouter, isNamedWindowInsert, processors, ExprNodeUtility.getEvaluators(whereClauses), agentInstanceContext);
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (newData == null) {
            return;
        }
        for (EventBean bean : newData) {
            boolean isHandled = this.handler.handle(bean, this.exprEvaluatorContext);
            if (isHandled) continue;
            this.updateChildren(new EventBean[]{bean}, null);
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return CollectionUtil.NULL_EVENT_ITERATOR;
    }
}

