/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EPException;
import java.io.Serializable;

public class BaseStatisticsBean
implements Cloneable,
Serializable {
    private double sumX;
    private double sumXSq;
    private double sumY;
    private double sumYSq;
    private double sumXY;
    private long dataPoints;
    private static final long serialVersionUID = 7985193760056277184L;

    private void initialize() {
        this.sumX = 0.0;
        this.sumXSq = 0.0;
        this.sumY = 0.0;
        this.sumYSq = 0.0;
        this.sumXY = 0.0;
        this.dataPoints = 0L;
    }

    public final void addPoint(double x) {
        ++this.dataPoints;
        this.sumX += x;
        this.sumXSq += x * x;
    }

    public final void addPoint(double x, double y) {
        ++this.dataPoints;
        this.sumX += x;
        this.sumXSq += x * x;
        this.sumY += y;
        this.sumYSq += y * y;
        this.sumXY += x * y;
    }

    public final void removePoint(double x) {
        --this.dataPoints;
        if (this.dataPoints <= 0L) {
            this.initialize();
        } else {
            this.sumX -= x;
            this.sumXSq -= x * x;
        }
    }

    public final void removePoint(double x, double y) {
        --this.dataPoints;
        if (this.dataPoints <= 0L) {
            this.initialize();
        } else {
            this.sumX -= x;
            this.sumXSq -= x * x;
            this.sumY -= y;
            this.sumYSq -= y * y;
            this.sumXY -= x * y;
        }
    }

    public final double getXStandardDeviationPop() {
        if (this.dataPoints == 0L) {
            return Double.NaN;
        }
        double temp = (this.sumXSq - this.sumX * this.sumX / (double)this.dataPoints) / (double)this.dataPoints;
        return Math.sqrt(temp);
    }

    public final double getYStandardDeviationPop() {
        if (this.dataPoints == 0L) {
            return Double.NaN;
        }
        double temp = (this.sumYSq - this.sumY * this.sumY / (double)this.dataPoints) / (double)this.dataPoints;
        return Math.sqrt(temp);
    }

    public final double getXStandardDeviationSample() {
        if (this.dataPoints < 2L) {
            return Double.NaN;
        }
        double variance = this.getXVariance();
        return Math.sqrt(variance);
    }

    public final double getYStandardDeviationSample() {
        if (this.dataPoints < 2L) {
            return Double.NaN;
        }
        double variance = this.getYVariance();
        return Math.sqrt(variance);
    }

    public final double getXVariance() {
        if (this.dataPoints < 2L) {
            return Double.NaN;
        }
        return (this.sumXSq - this.sumX * this.sumX / (double)this.dataPoints) / (double)(this.dataPoints - 1L);
    }

    public final double getYVariance() {
        if (this.dataPoints < 2L) {
            return Double.NaN;
        }
        return (this.sumYSq - this.sumY * this.sumY / (double)this.dataPoints) / (double)(this.dataPoints - 1L);
    }

    public final long getN() {
        return this.dataPoints;
    }

    public final double getXSum() {
        return this.sumX;
    }

    public final double getYSum() {
        return this.sumY;
    }

    public final double getXAverage() {
        if (this.dataPoints == 0L) {
            return Double.NaN;
        }
        return this.sumX / (double)this.dataPoints;
    }

    public final double getYAverage() {
        if (this.dataPoints == 0L) {
            return Double.NaN;
        }
        return this.sumY / (double)this.dataPoints;
    }

    public final double getSumXSq() {
        return this.sumXSq;
    }

    public final double getSumYSq() {
        return this.sumYSq;
    }

    public final double getSumXY() {
        return this.sumXY;
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new EPException(e);
        }
    }

    public final String toString() {
        return "datapoints=" + this.dataPoints + "  sumX=" + this.sumX + "  sumXSq=" + this.sumXSq + "  sumY=" + this.sumY + "  sumYSq=" + this.sumYSq + "  sumXY=" + this.sumXY;
    }

    public void setSumX(double sumX) {
        this.sumX = sumX;
    }

    public void setSumXSq(double sumXSq) {
        this.sumXSq = sumXSq;
    }

    public void setSumY(double sumY) {
        this.sumY = sumY;
    }

    public void setSumYSq(double sumYSq) {
        this.sumYSq = sumYSq;
    }

    public void setSumXY(double sumXY) {
        this.sumXY = sumXY;
    }

    public void setDataPoints(long dataPoints) {
        this.dataPoints = dataPoints;
    }

    public double getSumX() {
        return this.sumX;
    }

    public double getSumY() {
        return this.sumY;
    }

    public long getDataPoints() {
        return this.dataPoints;
    }

    public double getYIntercept() {
        double slope = this.getSlope();
        if (Double.isNaN(slope)) {
            return Double.NaN;
        }
        return this.getYSum() / (double)this.getN() - this.getSlope() * this.getXSum() / (double)this.getN();
    }

    public double getSlope() {
        if (this.getN() == 0L) {
            return Double.NaN;
        }
        double ssx = this.getSumXSq() - this.getXSum() * this.getXSum() / (double)this.getN();
        if (ssx == 0.0) {
            return Double.NaN;
        }
        double sp = this.getSumXY() - this.getXSum() * this.getYSum() / (double)this.getN();
        return sp / ssx;
    }

    public final double getCorrelation() {
        if (this.getN() == 0L) {
            return Double.NaN;
        }
        double dx = this.getSumXSq() - this.getXSum() * this.getXSum() / (double)this.getN();
        double dy = this.getSumYSq() - this.getYSum() * this.getYSum() / (double)this.getN();
        if (dx == 0.0 || dy == 0.0) {
            return Double.NaN;
        }
        double sp = this.getSumXY() - this.getXSum() * this.getYSum() / (double)this.getN();
        return sp / Math.sqrt(dx * dy);
    }
}

